/* 
 * PROJECT: NyWin32Capture
 * --------------------------------------------------------------------------------
 * The MIT License
 * Copyright (c) 2010 R.Iizuka NyARToolkit project
 * airmail(at)ebony.plala.or.jp
 * http://nyatla.jp/nyartoolkit/
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 */
#pragma once
#include <exception>
#include <vector>
#include <windows.h>
#include <strmif.h>
#include <amvideo.h>
#include <dshow.h>
#include <uuids.h>


namespace NyWin32Capture
{
	/**	̃NX́ANyWin32CaptureException̗O`܂B
	*/
	class NyWin32CaptureException :public std::exception
	{
	public:
		NyWin32CaptureException();
		NyWin32CaptureException(exception e);
		NyWin32CaptureException(const char* m);
	};
}

namespace NyWin32Capture
{
	/**	̃NX́A1̃rfItH[}bgi[Aelւ̃ANZX񋟂܂B
	*/
	class VideoFormat
	{
	private:
		//Rs[RXgN^폜
		VideoFormat(const VideoFormat& );
		VideoFormat& operator=(const VideoFormat&);
	private:
		AM_MEDIA_TYPE *_pmt;
		VIDEO_STREAM_CONFIG_CAPS* _scc;
	public:
		VideoFormat(AM_MEDIA_TYPE* i_pmt,const VIDEO_STREAM_CONFIG_CAPS& i_scc);
		virtual ~VideoFormat();
		int getWidth()const;
		int getHeight()const;
		double getRate()const;
		const GUID& getMediaSubType()const;
		const AM_MEDIA_TYPE* VideoFormat::getMediaType()const;
		const VIDEOINFOHEADER* getVideoInfoHeader()const;
		/**	tH[}bgBITMAPINFOHEADERԂ܂B
		*/
		const BITMAPINFOHEADER* getBitmapInfoHeader()const;
	public:
		/**	w肵p[^ŁABITMAPINFOHEADER\̂܂B
		*/
		static void initBITMAPINFOHEADER(int i_width,int i_height,const GUID& i_media_subtype,BITMAPINFOHEADER& o_bmih);
	};
}

namespace NyWin32Capture
{
	/**	̃NX́AVideofirmat̃Xg`܂B
	*/
	class VideoFormatList
	{
	private:
		//Rs[RXgN^폜
		VideoFormatList(const VideoFormatList& );
		VideoFormatList& operator=(const VideoFormatList&);
	private:
		std::vector<VideoFormat*> *_list;
		void clear();
	public:
		VideoFormatList();
		void update(IAMStreamConfig* i_config);
		virtual ~VideoFormatList();
		/**	̊֐́Aw肵tH[}bg(AAfBATu^Cv)ɍvVideoFormatXg猟܂B
			΁ÃtH[}bgւ̃|C^Ԃ܂B
			Ȃ΁ANULLԂ܂B
		*/
		const VideoFormat* getFormat(int i_width,int i_height,const GUID& i_media_type)const;
		/**	̊֐́Aw肵tH[}bg(A)ɍvVideoFormatXg猟܂B
			΁ÃtH[}bgւ̃|C^Ԃ܂B
			Ȃ΁ANULLԂ܂B
		*/
		const VideoFormat* getFormat(int i_width,int i_height)const;
		/**	̊֐́Ai_indexԖڂVideoFormatԂ܂B
		*/
		const VideoFormat* getFormat(int i_index)const;
		/**	XgLVideoFormat̐Ԃ܂B
		*/
		int getNumberOfFormat()const;
	};
}


struct ISampleGrabber;


namespace NyWin32Capture
{

	//class IMediaControl;

	class CaptureImageCallback;
	class CaptureDevice;
	/**	startCaptureCallbackĂяoR[obN֐łB
		̊֐̒Start,Stop̊֐ĂяoȂłB
	*/
	typedef void (*OnCaptureImage)(const CaptureDevice* i_sender,BYTE *pBuffer, long BufferLen);



	/**	̃NX́ALv`foCXP𐧌䂵܂B
		̃NX͂R̏ST_RUN,ST_IDLE,ST_CLOSED܂B
		Xe[^XƁAω֐̊֌W͈ȉ̒ʂłB

		
		|function name      | status transition
		|-------------------+---------------------
		|openDevice         | ST_CLOSED -> ST_IDLE
		|(setting functions)| -
		|startDevice        | ST_IDLE   -> ST_RUN
		|(capture funstion )| -
		|stopDevice         | ST_RUN    -> ST_IDLE
		|closeDevice        | ST_IDLE   -> ST_CLOSED

	*/
	class CaptureDevice
	{
	private:
		const static int ST_CLOSED=0;
		const static int ST_IDLE  =1;
		const static int ST_RUN=2;
	private:
		IMoniker*    _moniker;
		AM_MEDIA_TYPE _capture_mediatype;
		struct{
			struct{
				IBaseFilter* filter;
				IAMStreamConfig* config;
				IPin* pin;
			}sorce;
			struct{
				IMediaControl* mc;
				IGraphBuilder* graph;
			}graph_builder;
			struct{
				IBaseFilter* filter;
				ISampleGrabber* grab;
			}render;
		}ds_res;
		struct{
			WCHAR* name;
		}_allocated_res;
		int _status;
		CaptureImageCallback* _image_cb;
		void* _user_value;
		void mStartCapture(BOOL i_set_bffer_samples);
	public:
		CaptureDevice(IMoniker* i_moniker);
		virtual ~CaptureDevice();
		/**	[hŃLv`X^[g܂B
			̊֐ŊJnLv`́AcaptureImage֐ŃC[W擾邱Ƃł܂B
		*/
		void startCapture();
		/**	񓯊[hŃLv`X^[g܂B
			̊֐ŊJnLv`́AC[Wi_callback֐ɔ񓯊Œʒm܂B
			captureImage֐gƂ͂ł܂B
		*/
		void startCaptureCallback(OnCaptureImage i_callback);
		/**	Lv`~܂B
		*/
		void stopCapture();
		/**	Lv`foCXI[v܂B
		*/
		void openDevice();
		/**	Lv`foCXN[Y܂B
		*/
		void closeDevice();
		/** foCX̒񋟂łrfItH[}bg̈ꗗAo_listɕԂ܂B
			̊֐́AST_IDLE,ST_RUNXe[^X̂Ƃgp\łB
		*/
		void getVideoFormatList(VideoFormatList& o_list)const;
		/** Lv`C[W擾܂B
			̊֐́AstartCapture炵΂炭̊Ԏs邱Ƃ܂B
			̊֐́AstartCaptureŊJnAST_RUNXe[^X̂Ƃgp\łB
		*/
		bool captureImage(void* i_buf,long i_buf_size=0);
		/** Lv`C[W̃tH[}bgw肵܂B
			̊֐́AST_IDLEXe[^X̂Ƃgp\łB
		*/
		bool setVideoFormat(int i_width,int i_height,const GUID& i_media_subtype,double i_rate);
		/** Lv`C[W̃tH[}bgw肵܂B
			̊֐́AST_IDLEXe[^X̂Ƃgp\łB
		*/
		bool setVideoFormat(const VideoFormat& i_format,double i_rate);
		/** i_formatmedia_subtypetB[hăLv`C[W̃tH[}bgw肵܂B
			̊֐́AST_IDLEXe[^X̂Ƃgp\łB
		*/
		bool setVideoFormat(const VideoFormat& i_format,const GUID& i_media_subtype,double i_rate);

		/**	Lv`摜fBA^Cv擾܂B
		*/
		const AM_MEDIA_TYPE& getMediaType()const;
		/**	[U`l擾܂B
		*/
		void* getUserValue()const;
		/**	[U`lݒ肵܂B̒ĺAgetUserValueŎ擾ł܂B
			񓯊֐ɔCӂ̒lnƂɎgp܂B
		*/
		void setUserValue(void* i_user_value);
		/**	̃foCX̒l擾܂B
		*/
		const WCHAR* getName()const;
	};
}

namespace NyWin32Capture
{
	/**	̃NX́ALv`foCX̃Xg`ALv`foCXL܂B
	*/
	class CaptureDeviceList
	{
	private:
		void createDeviceList();
		void releaseDeviceList();
		std::vector<CaptureDevice*> *_list;
	public:
		CaptureDeviceList();
		virtual ~CaptureDeviceList();
		//	i_indexԖڂ̃Lv`foCX擾܂B
		CaptureDevice* getDevice(int i_index)const;
		//	foCX̐擾܂B
		int getNumberOfDevice()const;
	};
}