/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.Context;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Pipeline;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.VirtualUniverse;

class LineAttributesRetained
extends NodeComponentRetained {
    static final int LINE_WIDTH_CHANGED = 1;
    static final int LINE_PATTERN_CHANGED = 2;
    static final int LINE_AA_CHANGED = 4;
    static final int LINE_PATTERN_MASK_CHANGED = 8;
    static final int LINE_PATTERN_SCALEFACTOR_CHANGED = 16;
    float lineWidth = 1.0f;
    int linePattern = 0;
    boolean lineAntialiasing = false;
    int linePatternMask = 65535;
    int linePatternScaleFactor = 1;

    LineAttributesRetained() {
    }

    final void initLineWidth(float f) {
        this.lineWidth = f;
    }

    final void setLineWidth(float f) {
        this.initLineWidth(f);
        this.sendMessage(1, new Float(f));
    }

    final float getLineWidth() {
        return this.lineWidth;
    }

    final void initLinePattern(int n) {
        this.linePattern = n;
    }

    final void setLinePattern(int n) {
        this.initLinePattern(n);
        this.sendMessage(2, new Integer(n));
    }

    final int getLinePattern() {
        return this.linePattern;
    }

    final void initLineAntialiasingEnable(boolean bl) {
        this.lineAntialiasing = bl;
    }

    final void setLineAntialiasingEnable(boolean bl) {
        this.initLineAntialiasingEnable(bl);
        this.sendMessage(4, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    final boolean getLineAntialiasingEnable() {
        return this.lineAntialiasing;
    }

    final void initPatternMask(int n) {
        this.linePatternMask = n;
    }

    final void setPatternMask(int n) {
        this.initPatternMask(n);
        this.sendMessage(8, new Integer(n));
    }

    final int getPatternMask() {
        return this.linePatternMask;
    }

    final void initPatternScaleFactor(int n) {
        if (n < 1) {
            n = 1;
        } else if (n > 15) {
            n = 15;
        }
        this.linePatternScaleFactor = n;
    }

    final void setPatternScaleFactor(int n) {
        this.initPatternScaleFactor(n);
        this.sendMessage(16, new Integer(n));
    }

    final int getPatternScaleFactor() {
        return this.linePatternScaleFactor;
    }

    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            if (this.isStatic()) {
                this.mirror = this;
            } else {
                LineAttributesRetained lineAttributesRetained = new LineAttributesRetained();
                lineAttributesRetained.source = this.source;
                lineAttributesRetained.set(this);
                this.mirror = lineAttributesRetained;
            }
        } else {
            ((LineAttributesRetained)this.mirror).set(this);
        }
    }

    void updateNative(Context context) {
        Pipeline.getPipeline().updateLineAttributes(context, this.lineWidth, this.linePattern, this.linePatternMask, this.linePatternScaleFactor, this.lineAntialiasing);
    }

    synchronized void initMirrorObject() {
        ((LineAttributesRetained)this.mirror).set(this);
    }

    synchronized void updateMirrorObject(int n, Object object) {
        LineAttributesRetained lineAttributesRetained = (LineAttributesRetained)this.mirror;
        if ((n & 1) != 0) {
            lineAttributesRetained.lineWidth = ((Float)object).floatValue();
        } else if ((n & 2) != 0) {
            lineAttributesRetained.linePattern = (Integer)object;
        } else if ((n & 4) != 0) {
            lineAttributesRetained.lineAntialiasing = (Boolean)object;
        } else if ((n & 8) != 0) {
            lineAttributesRetained.linePatternMask = (Integer)object;
        } else if ((n & 0x10) != 0) {
            lineAttributesRetained.linePatternScaleFactor = (Integer)object;
        }
    }

    boolean equivalent(LineAttributesRetained lineAttributesRetained) {
        return lineAttributesRetained != null && this.lineWidth == lineAttributesRetained.lineWidth && this.linePattern == lineAttributesRetained.linePattern && this.lineAntialiasing == lineAttributesRetained.lineAntialiasing && this.linePatternMask == lineAttributesRetained.linePatternMask && this.linePatternScaleFactor == lineAttributesRetained.linePatternScaleFactor;
    }

    protected void set(LineAttributesRetained lineAttributesRetained) {
        super.set(lineAttributesRetained);
        this.lineWidth = lineAttributesRetained.lineWidth;
        this.linePattern = lineAttributesRetained.linePattern;
        this.linePatternScaleFactor = lineAttributesRetained.linePatternScaleFactor;
        this.linePatternMask = lineAttributesRetained.linePatternMask;
        this.lineAntialiasing = lineAttributesRetained.lineAntialiasing;
    }

    final void sendMessage(int n, Object object) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = Shape3DRetained.getGeomAtomsList(this.mirror.users, arrayList);
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 1024;
        j3dMessage.type = 7;
        j3dMessage.universe = null;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(j3dMessage);
        for (int i = 0; i < arrayList.size(); ++i) {
            j3dMessage = new J3dMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 7;
            j3dMessage.universe = (VirtualUniverse)arrayList.get(i);
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(n);
            j3dMessage.args[2] = object;
            ArrayList arrayList3 = (ArrayList)arrayList2.get(i);
            GeometryAtom[] geometryAtomArray = new GeometryAtom[arrayList3.size()];
            arrayList3.toArray(geometryAtomArray);
            j3dMessage.args[3] = geometryAtomArray;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void handleFrequencyChange(int n) {
        if (n == 1 || n == 3 || n == 5) {
            this.setFrequencyChangeMask(n, 1);
        }
    }
}

