package math;

public class TanTest {

	static void benchLoose() {
		long t = System.currentTimeMillis();
		for (double i = 0; i < 10000000.0; ++i)
			Math.tan(i);
		System.out.println("Loose:  " + (System.currentTimeMillis() - t) / 100
				+ "ns/call");
	}

	static void benchStrict() {
		long t = System.currentTimeMillis();
		for (double i = 0; i < 10000000.0; ++i)
			StrictMath.tan(i);
		System.out.println("Strict: " + (System.currentTimeMillis() - t) / 100
				+ "ns/call");
	}

	static void compare() {
		for (double i = 0; i < 10000000.0; ++i)
			if (Math.tan(i) != StrictMath.tan(i)) {
				System.out.println(Math.tan(i));
				System.out.println(StrictMath.tan(i));
			}
	}

	public static void main(String[] args) {
		while (true) {
			// compare();
			benchLoose();
			benchStrict();
		}
	}
}
