/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.param;

import jp.nyatla.nyartoolkit.core.NyARMat;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint3d;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix44;

public final class NyARPerspectiveProjectionMatrix
extends NyARDoubleMatrix44 {
    public NyARPerspectiveProjectionMatrix() {
        this.m32 = 0.0;
        this.m31 = 0.0;
        this.m30 = 0.0;
        this.m33 = 1.0;
    }

    private static double dot(double a1, double a2, double a3, double b1, double b2, double b3) {
        return a1 * b1 + a2 * b2 + a3 * b3;
    }

    private static double norm(double a, double b, double c) {
        return Math.sqrt(a * a + b * b + c * c);
    }

    public void decompMat(NyARMat o_cpara, NyARMat o_trans) {
        int c;
        double c23;
        double c22;
        double c21;
        double c20;
        double c13;
        double c12;
        double c11;
        double c10;
        double c03;
        double c02;
        double c01;
        double c00;
        if (this.m23 >= 0.0) {
            c00 = this.m00;
            c01 = this.m01;
            c02 = this.m02;
            c03 = this.m03;
            c10 = this.m10;
            c11 = this.m11;
            c12 = this.m12;
            c13 = this.m13;
            c20 = this.m20;
            c21 = this.m21;
            c22 = this.m22;
            c23 = this.m23;
        } else {
            c00 = -this.m00;
            c01 = -this.m01;
            c02 = -this.m02;
            c03 = -this.m03;
            c10 = -this.m10;
            c11 = -this.m11;
            c12 = -this.m12;
            c13 = -this.m13;
            c20 = -this.m20;
            c21 = -this.m21;
            c22 = -this.m22;
            c23 = -this.m23;
        }
        double[][] cpara = o_cpara.getArray();
        double[][] trans = o_trans.getArray();
        int r = 0;
        while (r < 3) {
            c = 0;
            while (c < 4) {
                cpara[r][c] = 0.0;
                ++c;
            }
            ++r;
        }
        cpara[2][2] = NyARPerspectiveProjectionMatrix.norm(c20, c21, c22);
        trans[2][0] = c20 / cpara[2][2];
        trans[2][1] = c21 / cpara[2][2];
        trans[2][2] = c22 / cpara[2][2];
        trans[2][3] = c23 / cpara[2][2];
        cpara[1][2] = NyARPerspectiveProjectionMatrix.dot(trans[2][0], trans[2][1], trans[2][2], c10, c11, c12);
        double rem1 = c10 - cpara[1][2] * trans[2][0];
        double rem2 = c11 - cpara[1][2] * trans[2][1];
        double rem3 = c12 - cpara[1][2] * trans[2][2];
        cpara[1][1] = NyARPerspectiveProjectionMatrix.norm(rem1, rem2, rem3);
        trans[1][0] = rem1 / cpara[1][1];
        trans[1][1] = rem2 / cpara[1][1];
        trans[1][2] = rem3 / cpara[1][1];
        cpara[0][2] = NyARPerspectiveProjectionMatrix.dot(trans[2][0], trans[2][1], trans[2][2], c00, c01, c02);
        cpara[0][1] = NyARPerspectiveProjectionMatrix.dot(trans[1][0], trans[1][1], trans[1][2], c00, c01, c02);
        rem1 = c00 - cpara[0][1] * trans[1][0] - cpara[0][2] * trans[2][0];
        rem2 = c01 - cpara[0][1] * trans[1][1] - cpara[0][2] * trans[2][1];
        rem3 = c02 - cpara[0][1] * trans[1][2] - cpara[0][2] * trans[2][2];
        cpara[0][0] = NyARPerspectiveProjectionMatrix.norm(rem1, rem2, rem3);
        trans[0][0] = rem1 / cpara[0][0];
        trans[0][1] = rem2 / cpara[0][0];
        trans[0][2] = rem3 / cpara[0][0];
        trans[1][3] = (c13 - cpara[1][2] * trans[2][3]) / cpara[1][1];
        trans[0][3] = (c03 - cpara[0][1] * trans[1][3] - cpara[0][2] * trans[2][3]) / cpara[0][0];
        r = 0;
        while (r < 3) {
            c = 0;
            while (c < 3) {
                double[] dArray = cpara[r];
                int n = c++;
                dArray[n] = dArray[n] / cpara[2][2];
            }
            ++r;
        }
    }

    public void changeScale(double i_scale) {
        this.m00 *= i_scale;
        this.m10 *= i_scale;
        this.m01 *= i_scale;
        this.m11 *= i_scale;
        this.m02 *= i_scale;
        this.m12 *= i_scale;
        this.m03 *= i_scale;
        this.m13 *= i_scale;
    }

    public final void project(NyARDoublePoint3d i_3dvertex, NyARDoublePoint2d o_2d) {
        double w = 1.0 / (i_3dvertex.z * this.m22);
        o_2d.x = (i_3dvertex.x * this.m00 + i_3dvertex.y * this.m01 + i_3dvertex.z * this.m02) * w;
        o_2d.y = (i_3dvertex.y * this.m11 + i_3dvertex.z * this.m12) * w;
    }

    public final void project(double i_x, double i_y, double i_z, NyARDoublePoint2d o_2d) {
        double w = 1.0 / (i_z * this.m22);
        o_2d.x = (i_x * this.m00 + i_y * this.m01 + i_z * this.m02) * w;
        o_2d.y = (i_y * this.m11 + i_z * this.m12) * w;
    }

    public final void project(NyARDoublePoint3d i_3dvertex, NyARIntPoint2d o_2d) {
        double w = 1.0 / (i_3dvertex.z * this.m22);
        o_2d.x = (int)((i_3dvertex.x * this.m00 + i_3dvertex.y * this.m01 + i_3dvertex.z * this.m02) * w);
        o_2d.y = (int)((i_3dvertex.y * this.m11 + i_3dvertex.z * this.m12) * w);
    }

    public final void project(double i_x, double i_y, double i_z, NyARIntPoint2d o_2d) {
        double w = 1.0 / (i_z * this.m22);
        o_2d.x = (int)((i_x * this.m00 + i_y * this.m01 + i_z * this.m02) * w);
        o_2d.y = (int)((i_y * this.m11 + i_z * this.m12) * w);
    }

    public void makeCameraFrustumRH(double i_screen_width, double i_screen_height, double i_dist_min, double i_dist_max, NyARDoubleMatrix44 o_frustum) {
        NyARMat trans_mat = new NyARMat(3, 4);
        NyARMat icpara_mat = new NyARMat(3, 4);
        double[][] p = new double[3][3];
        this.decompMat(icpara_mat, trans_mat);
        double[][] icpara = icpara_mat.getArray();
        double[][] trans = trans_mat.getArray();
        int i = 0;
        while (i < 4) {
            icpara[1][i] = (i_screen_height - 1.0) * icpara[2][i] - icpara[1][i];
            ++i;
        }
        p[0][0] = icpara[0][0] / icpara[2][2];
        p[0][1] = icpara[0][1] / icpara[2][2];
        p[0][2] = icpara[0][2] / icpara[2][2];
        p[1][0] = icpara[1][0] / icpara[2][2];
        p[1][1] = icpara[1][1] / icpara[2][2];
        p[1][2] = icpara[1][2] / icpara[2][2];
        p[2][0] = icpara[2][0] / icpara[2][2];
        p[2][1] = icpara[2][1] / icpara[2][2];
        p[2][2] = icpara[2][2] / icpara[2][2];
        double q00 = 2.0 * p[0][0] / (i_screen_width - 1.0);
        double q01 = 2.0 * p[0][1] / (i_screen_width - 1.0);
        double q02 = -(2.0 * p[0][2] / (i_screen_width - 1.0) - 1.0);
        double q03 = 0.0;
        o_frustum.m00 = q00 * trans[0][0] + q01 * trans[1][0] + q02 * trans[2][0];
        o_frustum.m01 = q00 * trans[0][1] + q01 * trans[1][1] + q02 * trans[2][1];
        o_frustum.m02 = q00 * trans[0][2] + q01 * trans[1][2] + q02 * trans[2][2];
        o_frustum.m03 = q00 * trans[0][3] + q01 * trans[1][3] + q02 * trans[2][3] + q03;
        double q10 = 0.0;
        double q11 = -(2.0 * p[1][1] / (i_screen_height - 1.0));
        double q12 = -(2.0 * p[1][2] / (i_screen_height - 1.0) - 1.0);
        double q13 = 0.0;
        o_frustum.m10 = q10 * trans[0][0] + q11 * trans[1][0] + q12 * trans[2][0];
        o_frustum.m11 = q10 * trans[0][1] + q11 * trans[1][1] + q12 * trans[2][1];
        o_frustum.m12 = q10 * trans[0][2] + q11 * trans[1][2] + q12 * trans[2][2];
        o_frustum.m13 = q10 * trans[0][3] + q11 * trans[1][3] + q12 * trans[2][3] + q13;
        double q20 = 0.0;
        double q21 = 0.0;
        double q22 = (i_dist_max + i_dist_min) / (i_dist_min - i_dist_max);
        double q23 = 2.0 * i_dist_max * i_dist_min / (i_dist_min - i_dist_max);
        o_frustum.m20 = q20 * trans[0][0] + q21 * trans[1][0] + q22 * trans[2][0];
        o_frustum.m21 = q20 * trans[0][1] + q21 * trans[1][1] + q22 * trans[2][1];
        o_frustum.m22 = q20 * trans[0][2] + q21 * trans[1][2] + q22 * trans[2][2];
        o_frustum.m23 = q20 * trans[0][3] + q21 * trans[1][3] + q22 * trans[2][3] + q23;
        double q30 = 0.0;
        double q31 = 0.0;
        double q32 = -1.0;
        double q33 = 0.0;
        o_frustum.m30 = q30 * trans[0][0] + q31 * trans[1][0] + q32 * trans[2][0];
        o_frustum.m31 = q30 * trans[0][1] + q31 * trans[1][1] + q32 * trans[2][1];
        o_frustum.m32 = q30 * trans[0][2] + q31 * trans[1][2] + q32 * trans[2][2];
        o_frustum.m33 = q30 * trans[0][3] + q31 * trans[1][3] + q32 * trans[2][3] + q33;
    }
}

