/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.raster;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.labeling.rlelabeling.NyARLabeling_Rle;
import jp.nyatla.nyartoolkit.core.pixeldriver.INyARGsPixelDriver;
import jp.nyatla.nyartoolkit.core.pixeldriver.NyARGsPixelDriverFactory;
import jp.nyatla.nyartoolkit.core.raster.INyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.rasterdriver.INyARHistogramFromRaster;
import jp.nyatla.nyartoolkit.core.rasterdriver.NyARHistogramFromRasterFactory;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARContourPickup;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARGrayscaleRaster
implements INyARGrayscaleRaster {
    protected final NyARIntSize _size;
    protected int _buffer_type;
    protected Object _buf;
    protected boolean _is_attached_buffer;
    protected INyARGsPixelDriver _pixdrv;

    @Override
    public final int getWidth() {
        return this._size.w;
    }

    @Override
    public final int getHeight() {
        return this._size.h;
    }

    @Override
    public final NyARIntSize getSize() {
        return this._size;
    }

    @Override
    public final int getBufferType() {
        return this._buffer_type;
    }

    @Override
    public final boolean isEqualBufferType(int i_type_value) {
        return this._buffer_type == i_type_value;
    }

    @Override
    public INyARGsPixelDriver getGsPixelDriver() throws NyARException {
        return this._pixdrv;
    }

    public NyARGrayscaleRaster(int i_width, int i_height) throws NyARException {
        this._size = new NyARIntSize(i_width, i_height);
        this._buffer_type = 262145;
        this.initInstance(this._size, 262145, true);
    }

    public NyARGrayscaleRaster(int i_width, int i_height, boolean i_is_alloc) throws NyARException {
        this._size = new NyARIntSize(i_width, i_height);
        this._buffer_type = 262145;
        this.initInstance(this._size, 262145, i_is_alloc);
    }

    public NyARGrayscaleRaster(int i_width, int i_height, int i_raster_type, boolean i_is_alloc) throws NyARException {
        this._size = new NyARIntSize(i_width, i_height);
        this._buffer_type = i_raster_type;
        this.initInstance(this._size, i_raster_type, i_is_alloc);
    }

    protected void initInstance(NyARIntSize i_size, int i_raster_type, boolean i_is_alloc) throws NyARException {
        switch (i_raster_type) {
            case 262145: {
                this._buf = i_is_alloc ? new int[i_size.w * i_size.h] : null;
                break;
            }
            default: {
                throw new NyARException();
            }
        }
        this._is_attached_buffer = i_is_alloc;
        this._pixdrv = NyARGsPixelDriverFactory.createDriver(this);
    }

    @Override
    public Object createInterface(Class<?> i_iid) throws NyARException {
        if (i_iid == NyARLabeling_Rle.IRasterDriver.class) {
            return NyARLabeling_Rle.RasterDriverFactory.createDriver(this);
        }
        if (i_iid == NyARContourPickup.IRasterDriver.class) {
            return NyARContourPickup.ImageDriverFactory.createDriver(this);
        }
        if (i_iid == INyARHistogramFromRaster.class) {
            return NyARHistogramFromRasterFactory.createInstance(this);
        }
        throw new NyARException();
    }

    @Override
    public Object getBuffer() {
        return this._buf;
    }

    @Override
    public boolean hasBuffer() {
        return this._buf != null;
    }

    @Override
    public void wrapBuffer(Object i_ref_buf) throws NyARException {
        assert (!this._is_attached_buffer);
        this._pixdrv.switchRaster(this);
        this._buf = i_ref_buf;
    }
}

