/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyar4psg;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.raster.NyARBinRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.rgb2bin.INyARRasterFilter_RgbToBin;
import jp.nyatla.nyartoolkit.core.rasterreader.INyARBufferReader;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

class ARToolkitThreshold4PImage
implements INyARRasterFilter_RgbToBin {
    private int _threshold;

    public void setThreshold(int i_threshold) {
        this._threshold = i_threshold;
    }

    public void doFilter(INyARRgbRaster i_input, NyARBinRaster i_output) throws NyARException {
        INyARBufferReader in_buffer_reader = i_input.getBufferReader();
        INyARBufferReader out_buffer_reader = i_output.getBufferReader();
        assert (out_buffer_reader.isEqualBufferType(262146));
        assert (in_buffer_reader.isEqualBufferType(262402));
        assert (i_input.getSize().isEqualSize(i_output.getSize()));
        NyARIntSize size = i_output.getSize();
        this.convert((int[])in_buffer_reader.getBuffer(), (int[])out_buffer_reader.getBuffer(), size);
    }

    private void convert(int[] i_in, int[] i_out, NyARIntSize i_size) {
        int w;
        int th = this._threshold * 3;
        int pix_count = i_size.h * i_size.w;
        int pix_mod_part = pix_count - pix_count % 8;
        int xy = pix_count - 1;
        while (xy >= pix_mod_part) {
            w = i_in[xy];
            i_out[xy] = (w & 0xFF) + (w >> 8 & 0xFF) + (w >> 16 & 0xFF) <= th ? 0 : 1;
            --xy;
        }
        while (xy >= 0) {
            w = i_in[xy];
            i_out[xy] = (w & 0xFF) + (w >> 8 & 0xFF) + (w >> 16 & 0xFF) <= th ? 0 : 1;
            w = i_in[--xy];
            i_out[xy] = (w & 0xFF) + (w >> 8 & 0xFF) + (w >> 16 & 0xFF) <= th ? 0 : 1;
            w = i_in[--xy];
            i_out[xy] = (w & 0xFF) + (w >> 8 & 0xFF) + (w >> 16 & 0xFF) <= th ? 0 : 1;
            w = i_in[--xy];
            i_out[xy] = (w & 0xFF) + (w >> 8 & 0xFF) + (w >> 16 & 0xFF) <= th ? 0 : 1;
            w = i_in[--xy];
            i_out[xy] = (w & 0xFF) + (w >> 8 & 0xFF) + (w >> 16 & 0xFF) <= th ? 0 : 1;
            w = i_in[--xy];
            i_out[xy] = (w & 0xFF) + (w >> 8 & 0xFF) + (w >> 16 & 0xFF) <= th ? 0 : 1;
            w = i_in[--xy];
            i_out[xy] = (w & 0xFF) + (w >> 8 & 0xFF) + (w >> 16 & 0xFF) <= th ? 0 : 1;
            w = i_in[--xy];
            i_out[xy] = (w & 0xFF) + (w >> 8 & 0xFF) + (w >> 16 & 0xFF) <= th ? 0 : 1;
            --xy;
        }
    }
}

