/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.jogl.utils;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARMat;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMatResult;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.jogl.utils.GLNyARRaster_RGB;

public class NyARGLUtil {
    private GL _gl;
    private GLU _glu;
    private double view_scale_factor = 0.025;
    private double view_distance_min = 0.1;
    private double view_distance_max = 100.0;

    public NyARGLUtil(GL i_gl) {
        this._gl = i_gl;
        this._glu = new GLU();
    }

    public void drawBackGround(GLNyARRaster_RGB i_raster, double i_zoom) {
        boolean depthTestSave;
        boolean lightingSave;
        IntBuffer texEnvModeSave = IntBuffer.allocate(1);
        GL gl = this._gl;
        NyARIntSize rsize = i_raster.getSize();
        gl.glGetTexEnviv(8960, 8704, texEnvModeSave);
        if (texEnvModeSave.array()[0] != 7681) {
            gl.glTexEnvi(8960, 8704, 7681);
        }
        if (lightingSave = gl.glIsEnabled(2896)) {
            gl.glDisable(2896);
        }
        if (depthTestSave = gl.glIsEnabled(2929)) {
            gl.glDisable(2929);
        }
        gl.glMatrixMode(5889);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        this._glu.gluOrtho2D(0.0, (double)rsize.w, 0.0, (double)rsize.h);
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        this.arglDispImageStateful(i_raster, i_zoom);
        gl.glMatrixMode(5889);
        gl.glPopMatrix();
        gl.glMatrixMode(5888);
        gl.glPopMatrix();
        if (depthTestSave) {
            gl.glEnable(2929);
        }
        if (lightingSave) {
            gl.glEnable(2896);
        }
        if (texEnvModeSave.get(0) != 7681) {
            gl.glTexEnvi(8960, 8704, texEnvModeSave.get(0));
        }
        gl.glEnd();
    }

    private void arglDispImageStateful(GLNyARRaster_RGB i_raster, double zoom) {
        GL gl_ = this._gl;
        NyARIntSize rsize = i_raster.getSize();
        IntBuffer params = IntBuffer.allocate(4);
        float zoomf = (float)zoom;
        gl_.glDisable(3553);
        gl_.glGetIntegerv(2978, params);
        gl_.glPixelZoom(zoomf * ((float)params.get(2) / (float)rsize.w), -zoomf * ((float)params.get(3) / (float)rsize.h));
        gl_.glWindowPos2f(0.0f, (float)rsize.h);
        gl_.glPixelStorei(3317, 1);
        ByteBuffer buf = ByteBuffer.wrap(i_raster.getGLRgbArray());
        gl_.glDrawPixels(rsize.w, rsize.h, i_raster.getGLPixelFlag(), 5121, (Buffer)buf);
    }

    public void setScaleFactor(double i_new_value) {
        this.view_scale_factor = i_new_value;
    }

    public void setViewDistanceMin(double i_new_value) {
        this.view_distance_min = i_new_value;
    }

    public void setViewDistanceMax(double i_new_value) {
        this.view_distance_max = i_new_value;
    }

    public void toCameraFrustumRH(NyARParam i_arparam, double[] o_gl_projection) {
        int j;
        NyARMat trans_mat = new NyARMat(3, 4);
        NyARMat icpara_mat = new NyARMat(3, 4);
        double[][] p = new double[3][3];
        double[][] q = new double[4][4];
        NyARIntSize size = i_arparam.getScreenSize();
        int width = size.w;
        int height = size.h;
        i_arparam.getPerspectiveProjectionMatrix().decompMat(icpara_mat, trans_mat);
        double[][] icpara = icpara_mat.getArray();
        double[][] trans = trans_mat.getArray();
        int i = 0;
        while (i < 4) {
            icpara[1][i] = (double)(height - 1) * icpara[2][i] - icpara[1][i];
            ++i;
        }
        i = 0;
        while (i < 3) {
            j = 0;
            while (j < 3) {
                p[i][j] = icpara[i][j] / icpara[2][2];
                ++j;
            }
            ++i;
        }
        q[0][0] = 2.0 * p[0][0] / (double)(width - 1);
        q[0][1] = 2.0 * p[0][1] / (double)(width - 1);
        q[0][2] = -(2.0 * p[0][2] / (double)(width - 1) - 1.0);
        q[0][3] = 0.0;
        q[1][0] = 0.0;
        q[1][1] = -(2.0 * p[1][1] / (double)(height - 1));
        q[1][2] = -(2.0 * p[1][2] / (double)(height - 1) - 1.0);
        q[1][3] = 0.0;
        q[2][0] = 0.0;
        q[2][1] = 0.0;
        q[2][2] = (this.view_distance_max + this.view_distance_min) / (this.view_distance_min - this.view_distance_max);
        q[2][3] = 2.0 * this.view_distance_max * this.view_distance_min / (this.view_distance_min - this.view_distance_max);
        q[3][0] = 0.0;
        q[3][1] = 0.0;
        q[3][2] = -1.0;
        q[3][3] = 0.0;
        i = 0;
        while (i < 4) {
            j = 0;
            while (j < 3) {
                o_gl_projection[i + j * 4] = q[i][0] * trans[0][j] + q[i][1] * trans[1][j] + q[i][2] * trans[2][j];
                ++j;
            }
            o_gl_projection[i + 12] = q[i][0] * trans[0][3] + q[i][1] * trans[1][3] + q[i][2] * trans[2][3] + q[i][3];
            ++i;
        }
    }

    public void toCameraViewRH(NyARTransMatResult i_ny_result, double[] o_gl_result) throws NyARException {
        o_gl_result[0] = i_ny_result.m00;
        o_gl_result[4] = i_ny_result.m01;
        o_gl_result[8] = i_ny_result.m02;
        o_gl_result[12] = i_ny_result.m03;
        o_gl_result[1] = -i_ny_result.m10;
        o_gl_result[5] = -i_ny_result.m11;
        o_gl_result[9] = -i_ny_result.m12;
        o_gl_result[13] = -i_ny_result.m13;
        o_gl_result[2] = -i_ny_result.m20;
        o_gl_result[6] = -i_ny_result.m21;
        o_gl_result[10] = -i_ny_result.m22;
        o_gl_result[14] = -i_ny_result.m23;
        o_gl_result[3] = 0.0;
        o_gl_result[7] = 0.0;
        o_gl_result[11] = 0.0;
        o_gl_result[15] = 1.0;
        if (this.view_scale_factor != 0.0) {
            o_gl_result[12] = o_gl_result[12] * this.view_scale_factor;
            o_gl_result[13] = o_gl_result[13] * this.view_scale_factor;
            o_gl_result[14] = o_gl_result[14] * this.view_scale_factor;
        }
    }
}

