/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core;

import java.io.FileInputStream;
import java.io.InputStream;
import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARCodeFileReader;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPattDeviationBlackWhiteData;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPattDeviationColorData;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;

public class NyARCode {
    private NyARMatchPattDeviationColorData[] _color_pat = new NyARMatchPattDeviationColorData[4];
    private NyARMatchPattDeviationBlackWhiteData[] _bw_pat = new NyARMatchPattDeviationBlackWhiteData[4];
    private int _width;
    private int _height;

    public NyARMatchPattDeviationColorData getColorData(int i_index) {
        return this._color_pat[i_index];
    }

    public NyARMatchPattDeviationBlackWhiteData getBlackWhiteData(int i_index) {
        return this._bw_pat[i_index];
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public NyARCode(int i_width, int i_height) throws NyARException {
        this._width = i_width;
        this._height = i_height;
        int i = 0;
        while (i < 4) {
            this._color_pat[i] = new NyARMatchPattDeviationColorData(i_width, i_height);
            this._bw_pat[i] = new NyARMatchPattDeviationBlackWhiteData(i_width, i_height);
            ++i;
        }
    }

    public void loadARPattFromFile(String filename) throws NyARException {
        try {
            this.loadARPatt(new FileInputStream(filename));
        }
        catch (Exception e) {
            throw new NyARException(e);
        }
    }

    public void loadARPatt(InputStream i_stream) throws NyARException {
        NyARCodeFileReader.loadFromARToolKitFormFile(i_stream, this);
    }

    public void setRaster(INyARRgbRaster[] i_raster) throws NyARException {
        assert (i_raster.length != 4);
        int i = 0;
        while (i < 4) {
            this._color_pat[i].setRaster(i_raster[i]);
            ++i;
        }
    }

    public void setRaster(INyARRgbRaster i_raster) throws NyARException {
        int i = 0;
        while (i < 4) {
            this._color_pat[i].setRaster(i_raster, i);
            ++i;
        }
    }
}

