/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.types;

import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;

public class NyARIntRect {
    public int x;
    public int y;
    public int w;
    public int h;

    public NyARIntRect() {
    }

    public NyARIntRect(int i_x, int i_y, int i_w, int i_h) {
        this.setValue(i_x, i_y, i_w, i_h);
    }

    public final void setAreaRect(NyARDoublePoint2d[] i_vertex, int i_num_of_vertex) {
        int ymax;
        int xmax;
        int xmin = xmax = (int)i_vertex[i_num_of_vertex - 1].x;
        int ymin = ymax = (int)i_vertex[i_num_of_vertex - 1].y;
        int i = i_num_of_vertex - 2;
        while (i >= 0) {
            if (i_vertex[i].x < (double)xmin) {
                xmin = (int)i_vertex[i].x;
            } else if (i_vertex[i].x > (double)xmax) {
                xmax = (int)i_vertex[i].x;
            }
            if (i_vertex[i].y < (double)ymin) {
                ymin = (int)i_vertex[i].y;
            } else if (i_vertex[i].y > (double)ymax) {
                ymax = (int)i_vertex[i].y;
            }
            --i;
        }
        this.h = ymax - ymin + 1;
        this.x = xmin;
        this.w = xmax - xmin + 1;
        this.y = ymin;
    }

    public final void setAreaRect(NyARIntPoint2d[] i_vertex, int i_num_of_vertex) {
        int ymax;
        int xmax;
        int xmin = xmax = i_vertex[i_num_of_vertex - 1].x;
        int ymin = ymax = i_vertex[i_num_of_vertex - 1].y;
        int i = i_num_of_vertex - 2;
        while (i >= 0) {
            if (i_vertex[i].x < xmin) {
                xmin = i_vertex[i].x;
            } else if (i_vertex[i].x > xmax) {
                xmax = i_vertex[i].x;
            }
            if (i_vertex[i].y < ymin) {
                ymin = i_vertex[i].y;
            } else if (i_vertex[i].y > ymax) {
                ymax = i_vertex[i].y;
            }
            --i;
        }
        this.h = ymax - ymin + 1;
        this.x = xmin;
        this.w = xmax - xmin + 1;
        this.y = ymin;
    }

    public final void clip(int i_left, int i_top, int i_right, int i_bottom) {
        int x = this.x;
        int y = this.y;
        int r = x + this.w - 1;
        int b = y + this.h - 1;
        if (x < i_left) {
            x = i_left;
        } else if (x > i_right) {
            x = i_right;
        }
        if (y < i_top) {
            y = i_top;
        } else if (y > i_bottom) {
            y = i_bottom;
        }
        int l = r > i_right ? i_right - x : r - x;
        this.w = l < 0 ? 0 : l + 1;
        l = b > i_bottom ? i_bottom - y : b - y;
        this.h = l < 0 ? 0 : l + 1;
        this.x = x;
        this.y = y;
    }

    public final boolean isInnerPoint(int i_x, int i_y) {
        int x = i_x - this.x;
        int y = i_y - this.y;
        return x >= 0 && x < this.w && y >= 0 && y < this.h;
    }

    public final boolean isInnerPoint(NyARDoublePoint2d i_pos) {
        int x = (int)i_pos.x - this.x;
        int y = (int)i_pos.y - this.y;
        return x >= 0 && x < this.w && y >= 0 && y < this.h;
    }

    public final boolean isInnerPoint(NyARIntPoint2d i_pos) {
        int x = i_pos.x - this.x;
        int y = i_pos.y - this.y;
        return x >= 0 && x < this.w && y >= 0 && y < this.h;
    }

    public final boolean isInnerRect(NyARIntRect i_rect) {
        assert (i_rect.w >= 0 && i_rect.h >= 0);
        int lx = i_rect.x - this.x;
        int ly = i_rect.y - this.y;
        int lw = lx + i_rect.w;
        int lh = ly + i_rect.h;
        return lx >= 0 && lx < this.w && ly >= 0 && ly < this.h && lw <= this.w && lh <= this.h;
    }

    public final boolean isInnerRect(int i_x, int i_y, int i_w, int i_h) {
        assert (i_w >= 0 && i_h >= 0);
        int lx = i_x - this.x;
        int ly = i_y - this.y;
        int lw = lx + i_w;
        int lh = ly + i_h;
        return lx >= 0 && lx < this.w && ly >= 0 && ly < this.h && lw <= this.w && lh <= this.h;
    }

    public final int sqDiagonalPointDiff(NyARIntRect i_rect2) {
        int w1 = this.x - i_rect2.x;
        int w2 = this.y - i_rect2.y;
        int ret = w1 * w1 + w2 * w2;
        return ret += (w1 += this.w - i_rect2.w) * w1 + (w2 += this.h - i_rect2.h) * w2;
    }

    public final int getDiagonalSqDist() {
        int lh = this.h;
        int lw = this.w;
        return lh * lh + lw * lw;
    }

    public final void setValue(NyARIntRect i_source) {
        this.x = i_source.x;
        this.y = i_source.y;
        this.h = i_source.h;
        this.w = i_source.w;
    }

    public final void setValue(int i_x, int i_y, int i_w, int i_h) {
        this.x = i_x;
        this.y = i_y;
        this.h = i_h;
        this.w = i_w;
    }
}

