/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.pickup;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.pickup.INyARColorPatt;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterreader.INyARRgbPixelReader;
import jp.nyatla.nyartoolkit.core.rasterreader.NyARRgbPixelReader_INT1D_X8R8G8B8_32;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.core.utils.NyARPerspectiveParamGenerator;
import jp.nyatla.nyartoolkit.core.utils.NyARPerspectiveParamGenerator_O1;

public class NyARColorPatt_Perspective
implements INyARColorPatt {
    protected int[] _patdata;
    protected NyARIntPoint2d _pickup_lt = new NyARIntPoint2d();
    protected NyARIntSize _pickup_wh = new NyARIntSize();
    protected int _resolution;
    protected NyARIntSize _size;
    protected NyARPerspectiveParamGenerator _perspective_gen;
    private NyARRgbPixelReader_INT1D_X8R8G8B8_32 _pixelreader;
    private static final int LOCAL_LT = 1;
    private static final int BUFFER_FORMAT = 262402;
    private final int[] __pickFromRaster_rgb_tmp = new int[3];
    protected final double[] __pickFromRaster_cpara = new double[8];

    private void initializeInstance(int i_width, int i_height, int i_point_per_pix) {
        assert (i_width > 2 && i_height > 2);
        this._size = new NyARIntSize(i_width, i_height);
        this._patdata = new int[i_height * i_width];
        this._pixelreader = new NyARRgbPixelReader_INT1D_X8R8G8B8_32(this._patdata, this._size);
    }

    public NyARColorPatt_Perspective(int i_width, int i_height, int i_point_per_pix) {
        this.initializeInstance(i_width, i_height, i_point_per_pix);
        this.setEdgeSize(0, 0, i_point_per_pix);
    }

    public NyARColorPatt_Perspective(int i_width, int i_height, int i_point_per_pix, int i_edge_percentage) {
        this.initializeInstance(i_width, i_height, i_point_per_pix);
        this.setEdgeSizeByPercent(i_edge_percentage, i_edge_percentage, i_point_per_pix);
    }

    public void setEdgeSize(int i_x_edge, int i_y_edge, int i_resolution) {
        assert (i_x_edge >= 0);
        assert (i_y_edge >= 0);
        this._perspective_gen = new NyARPerspectiveParamGenerator_O1(1, 1);
        this._pickup_lt.setValue(i_x_edge * i_resolution + 1, i_y_edge * i_resolution + 1);
        this._pickup_wh.setValue((i_x_edge * 2 + this._size.w) * i_resolution, (i_y_edge * 2 + this._size.h) * i_resolution);
        this._resolution = i_resolution;
    }

    public void setEdgeSizeByPercent(int i_x_percent, int i_y_percent, int i_resolution) {
        assert (i_x_percent >= 0);
        assert (i_y_percent >= 0);
        this.setEdgeSize(this._size.w * i_x_percent / 50, this._size.h * i_y_percent / 50, i_resolution);
    }

    @Override
    public final int getWidth() {
        return this._size.w;
    }

    @Override
    public final int getHeight() {
        return this._size.h;
    }

    @Override
    public final NyARIntSize getSize() {
        return this._size;
    }

    @Override
    public final INyARRgbPixelReader getRgbPixelReader() {
        return this._pixelreader;
    }

    @Override
    public Object getBuffer() {
        return this._patdata;
    }

    @Override
    public boolean hasBuffer() {
        return this._patdata != null;
    }

    @Override
    public void wrapBuffer(Object i_ref_buf) throws NyARException {
        NyARException.notImplement();
    }

    @Override
    public final int getBufferType() {
        return 262402;
    }

    @Override
    public final boolean isEqualBufferType(int i_type_value) {
        return 262402 == i_type_value;
    }

    @Override
    public boolean pickFromRaster(INyARRgbRaster image, NyARIntPoint2d[] i_vertexs) throws NyARException {
        double[] cpara = this.__pickFromRaster_cpara;
        if (!this._perspective_gen.getParam(this._pickup_wh, i_vertexs, cpara)) {
            return false;
        }
        int resolution = this._resolution;
        int img_x = image.getWidth();
        int img_y = image.getHeight();
        int res_pix = resolution * resolution;
        int[] rgb_tmp = this.__pickFromRaster_rgb_tmp;
        INyARRgbPixelReader reader = image.getRgbPixelReader();
        int p = 0;
        int iy = 0;
        while (iy < this._size.h * resolution) {
            int ix = 0;
            while (ix < this._size.w * resolution) {
                int b = 0;
                int g = 0;
                int r = 0;
                int i2y = iy;
                while (i2y < iy + resolution) {
                    int cy = this._pickup_lt.y + i2y;
                    int i2x = ix;
                    while (i2x < ix + resolution) {
                        int cx = this._pickup_lt.x + i2x;
                        double d = cpara[6] * (double)cx + cpara[7] * (double)cy + 1.0;
                        int x = (int)((cpara[0] * (double)cx + cpara[1] * (double)cy + cpara[2]) / d);
                        int y = (int)((cpara[3] * (double)cx + cpara[4] * (double)cy + cpara[5]) / d);
                        if (x < 0) {
                            x = 0;
                        }
                        if (x >= img_x) {
                            x = img_x - 1;
                        }
                        if (y < 0) {
                            y = 0;
                        }
                        if (y >= img_y) {
                            y = img_y - 1;
                        }
                        reader.getPixel(x, y, rgb_tmp);
                        r += rgb_tmp[0];
                        g += rgb_tmp[1];
                        b += rgb_tmp[2];
                        ++i2x;
                    }
                    ++i2y;
                }
                this._patdata[p] = ((r /= res_pix) & 0xFF) << 16 | ((g /= res_pix) & 0xFF) << 8 | (b /= res_pix) & 0xFF;
                ++p;
                ix += resolution;
            }
            iy += resolution;
        }
        return true;
    }
}

