/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterreader;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.rasterreader.INyARRgbPixelReader;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public final class NyARRgbPixelReader_WORD1D_R5G6B5_16LE
implements INyARRgbPixelReader {
    protected short[] _ref_buf;
    private NyARIntSize _size;

    public NyARRgbPixelReader_WORD1D_R5G6B5_16LE(short[] i_buf, NyARIntSize i_size) {
        this._ref_buf = i_buf;
        this._size = i_size;
    }

    @Override
    public void getPixel(int i_x, int i_y, int[] o_rgb) {
        short[] buf = this._ref_buf;
        int y = i_y;
        int idx = y * this._size.w + i_x;
        int pixcel = buf[idx] & 0xFFFF;
        o_rgb[0] = (pixcel & 0xF800) >> 8;
        o_rgb[1] = (pixcel & 0x7E0) >> 3;
        o_rgb[2] = (pixcel & 0x1F) << 3;
    }

    @Override
    public void getPixelSet(int[] i_x, int[] i_y, int i_num, int[] o_rgb) {
        int stride = this._size.w;
        short[] buf = this._ref_buf;
        int i = i_num - 1;
        while (i >= 0) {
            int idx = i_y[i] * stride + i_x[i];
            int pixcel = buf[idx] & 0xFFFF;
            o_rgb[i * 3 + 0] = (pixcel & 0xF800) >> 8;
            o_rgb[i * 3 + 1] = (pixcel & 0x7E0) >> 3;
            o_rgb[i * 3 + 2] = (pixcel & 0x1F) << 3;
            --i;
        }
    }

    @Override
    public void setPixel(int i_x, int i_y, int[] i_rgb) throws NyARException {
        NyARException.notImplement();
    }

    @Override
    public void setPixel(int i_x, int i_y, int i_r, int i_g, int i_b) throws NyARException {
        NyARException.notImplement();
    }

    @Override
    public void setPixels(int[] i_x, int[] i_y, int i_num, int[] i_intrgb) throws NyARException {
        NyARException.notImplement();
    }

    @Override
    public void switchBuffer(Object i_ref_buffer) throws NyARException {
        assert (((short[])i_ref_buffer).length >= this._size.w * this._size.h);
        this._ref_buf = (short[])i_ref_buffer;
    }
}

