/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.sample;

import java.io.File;
import java.io.FileInputStream;
import java.util.Date;
import jp.nyatla.nyartoolkit.core.NyARCode;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.raster.rgb.NyARRgbRaster_BGRA;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMatResult;
import jp.nyatla.nyartoolkit.detector.NyARSingleDetectMarker;

public class RawFileTest {
    private final String code_file = "../Data/patt.hiro";
    private final String data_file = "../Data/320x240ABGR.raw";
    private final String camera_file = "../Data/camera_para.dat";

    public void Test_arDetectMarkerLite() throws Exception {
        NyARParam ap = new NyARParam();
        ap.loadARParamFromFile("../Data/camera_para.dat");
        ap.changeScreenSize(320, 240);
        NyARCode code = new NyARCode(16, 16);
        code.loadARPattFromFile("../Data/patt.hiro");
        File f = new File("../Data/320x240ABGR.raw");
        FileInputStream fs = new FileInputStream("../Data/320x240ABGR.raw");
        byte[] buf = new byte[(int)f.length()];
        fs.read(buf);
        NyARRgbRaster_BGRA ra = NyARRgbRaster_BGRA.wrap(buf, 320, 240);
        NyARSingleDetectMarker ar = new NyARSingleDetectMarker(ap, code, 80.0);
        NyARTransMatResult result_mat = new NyARTransMatResult();
        ar.setContinueMode(false);
        ar.detectMarkerLite(ra, 100);
        ar.getTransmationMatrix(result_mat);
        Date d2 = new Date();
        int i = 0;
        while (i < 1000) {
            ar.detectMarkerLite(ra, 100);
            ar.getTransmationMatrix(result_mat);
            ++i;
        }
        Date d = new Date();
        System.out.println(d.getTime() - d2.getTime());
    }

    public static void main(String[] args) {
        try {
            RawFileTest t = new RawFileTest();
            t.Test_arDetectMarkerLite();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

