/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.INyARSquareDetector;
import jp.nyatla.nyartoolkit.core.NyARSquare;
import jp.nyatla.nyartoolkit.core.NyARSquareStack;
import jp.nyatla.nyartoolkit.core.NyARVertexCounter;
import jp.nyatla.nyartoolkit.core.OverlapChecker;
import jp.nyatla.nyartoolkit.core.labeling.NyARLabelingImage;
import jp.nyatla.nyartoolkit.core.labeling.NyARLabelingLabel;
import jp.nyatla.nyartoolkit.core.labeling.NyARLabelingLabelStack;
import jp.nyatla.nyartoolkit.core.labeling.NyARLabeling_ARToolKit;
import jp.nyatla.nyartoolkit.core.param.NyARCameraDistortionFactor;
import jp.nyatla.nyartoolkit.core.param.NyARObserv2IdealMap;
import jp.nyatla.nyartoolkit.core.pca2d.INyARPca2d;
import jp.nyatla.nyartoolkit.core.pca2d.NyARPca2d_MatrixPCA_O2;
import jp.nyatla.nyartoolkit.core.raster.NyARBinRaster;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.core.types.NyARLinear;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix22;

public class NyARSquareDetector
implements INyARSquareDetector {
    private static final double VERTEX_FACTOR = 1.0;
    private static final int AR_AREA_MAX = 100000;
    private static final int AR_AREA_MIN = 70;
    private final int _width;
    private final int _height;
    private final NyARLabeling_ARToolKit _labeling;
    private final NyARLabelingImage _limage;
    private final OverlapChecker _overlap_checker = new OverlapChecker();
    private final NyARObserv2IdealMap _dist_factor;
    private final double[] _xpos;
    private final double[] _ypos;
    private final int _max_coord;
    private final int[] _xcoord;
    private final int[] _ycoord;
    private final int[] __detectMarker_mkvertex = new int[5];
    private final NyARVertexCounter __getSquareVertex_wv1 = new NyARVertexCounter();
    private final NyARVertexCounter __getSquareVertex_wv2 = new NyARVertexCounter();
    private final INyARPca2d _pca;
    private final NyARDoubleMatrix22 __getSquareLine_evec = new NyARDoubleMatrix22();
    private final NyARDoublePoint2d __getSquareLine_mean = new NyARDoublePoint2d();
    private final NyARDoublePoint2d __getSquareLine_ev = new NyARDoublePoint2d();

    public NyARSquareDetector(NyARCameraDistortionFactor i_dist_factor_ref, NyARIntSize i_size) throws NyARException {
        int number_of_coord;
        this._width = i_size.w;
        this._height = i_size.h;
        this._dist_factor = new NyARObserv2IdealMap(i_dist_factor_ref, i_size);
        this._labeling = new NyARLabeling_ARToolKit();
        this._limage = new NyARLabelingImage(this._width, this._height);
        this._labeling.attachDestination(this._limage);
        this._max_coord = number_of_coord = (this._width + this._height) * 2;
        this._xcoord = new int[number_of_coord * 2];
        this._ycoord = new int[number_of_coord * 2];
        this._pca = new NyARPca2d_MatrixPCA_O2();
        this._xpos = new double[this._width + this._height];
        this._ypos = new double[this._width + this._height];
    }

    private void normalizeCoord(int[] i_coord_x, int[] i_coord_y, int i_index, int i_coord_num) {
        System.arraycopy(i_coord_x, 1, i_coord_x, i_coord_num, i_index);
        System.arraycopy(i_coord_y, 1, i_coord_y, i_coord_num, i_index);
    }

    public final void detectMarker(NyARBinRaster i_raster, NyARSquareStack o_square_stack) throws NyARException {
        NyARLabelingImage limage = this._limage;
        o_square_stack.clear();
        this._labeling.labeling(i_raster);
        int label_num = limage.getLabelStack().getLength();
        if (label_num < 1) {
            return;
        }
        NyARLabelingLabelStack stack = limage.getLabelStack();
        NyARLabelingLabel[] labels = (NyARLabelingLabel[])stack.getArray();
        stack.sortByArea();
        int i = 0;
        while (i < label_num) {
            if (labels[i].area <= 100000) break;
            ++i;
        }
        int xsize = this._width;
        int ysize = this._height;
        int[] xcoord = this._xcoord;
        int[] ycoord = this._ycoord;
        int coord_max = this._max_coord;
        int[] mkvertex = this.__detectMarker_mkvertex;
        OverlapChecker overlap = this._overlap_checker;
        overlap.reset(label_num);
        while (i < label_num) {
            int coord_num;
            NyARLabelingLabel label_pt = labels[i];
            int label_area = label_pt.area;
            if (label_area < 70) break;
            if (label_pt.clip_l != 1 && label_pt.clip_r != xsize - 2 && label_pt.clip_t != 1 && label_pt.clip_b != ysize - 2 && overlap.check(label_pt) && (coord_num = limage.getContour(i, coord_max, xcoord, ycoord)) != coord_max) {
                int vertex1 = this.scanVertex(xcoord, ycoord, coord_num);
                this.normalizeCoord(xcoord, ycoord, vertex1, coord_num);
                NyARSquare square_ptr = (NyARSquare)o_square_stack.prePush();
                if (!this.getSquareVertex(xcoord, ycoord, vertex1, coord_num, label_area, mkvertex)) {
                    o_square_stack.pop();
                } else if (!this.getSquareLine(mkvertex, xcoord, ycoord, square_ptr)) {
                    o_square_stack.pop();
                } else {
                    overlap.push(label_pt);
                }
            }
            ++i;
        }
    }

    private int scanVertex(int[] i_xcoord, int[] i_ycoord, int i_coord_num) {
        int sx = i_xcoord[0];
        int sy = i_ycoord[0];
        int d = 0;
        int ret = 0;
        int i = 1;
        while (i < i_coord_num) {
            int x = i_xcoord[i] - sx;
            int y = i_ycoord[i] - sy;
            int w = x * x + y * y;
            if (w > d) {
                d = w;
                ret = i;
            }
            ++i;
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean getSquareVertex(int[] i_x_coord, int[] i_y_coord, int i_vertex1_index, int i_coord_num, int i_area, int[] o_vertex) {
        NyARVertexCounter wv1 = this.__getSquareVertex_wv1;
        NyARVertexCounter wv2 = this.__getSquareVertex_wv2;
        int end_of_coord = i_vertex1_index + i_coord_num - 1;
        int sx = i_x_coord[i_vertex1_index];
        int sy = i_y_coord[i_vertex1_index];
        int dmax = 0;
        int v1 = i_vertex1_index;
        int i = 1 + i_vertex1_index;
        while (i < end_of_coord) {
            int d = (i_x_coord[i] - sx) * (i_x_coord[i] - sx) + (i_y_coord[i] - sy) * (i_y_coord[i] - sy);
            if (d > dmax) {
                dmax = d;
                v1 = i;
            }
            ++i;
        }
        double thresh = (double)i_area / 0.75 * 0.01 * 1.0;
        o_vertex[0] = i_vertex1_index;
        if (!wv1.getVertex(i_x_coord, i_y_coord, i_vertex1_index, v1, thresh)) {
            return false;
        }
        if (!wv2.getVertex(i_x_coord, i_y_coord, v1, end_of_coord, thresh)) {
            return false;
        }
        if (wv1.number_of_vertex == 1 && wv2.number_of_vertex == 1) {
            o_vertex[1] = wv1.vertex[0];
            o_vertex[2] = v1;
            o_vertex[3] = wv2.vertex[0];
        } else if (wv1.number_of_vertex > 1 && wv2.number_of_vertex == 0) {
            int v2 = (v1 - i_vertex1_index) / 2 + i_vertex1_index;
            if (!wv1.getVertex(i_x_coord, i_y_coord, i_vertex1_index, v2, thresh)) {
                return false;
            }
            if (!wv2.getVertex(i_x_coord, i_y_coord, v2, v1, thresh)) {
                return false;
            }
            if (wv1.number_of_vertex != 1 || wv2.number_of_vertex != 1) return false;
            o_vertex[1] = wv1.vertex[0];
            o_vertex[2] = wv2.vertex[0];
            o_vertex[3] = v1;
        } else {
            if (wv1.number_of_vertex != 0 || wv2.number_of_vertex <= 1) return false;
            int v2 = (v1 + end_of_coord) / 2;
            if (!wv1.getVertex(i_x_coord, i_y_coord, v1, v2, thresh)) {
                return false;
            }
            if (!wv2.getVertex(i_x_coord, i_y_coord, v2, end_of_coord, thresh)) {
                return false;
            }
            if (wv1.number_of_vertex != 1 || wv2.number_of_vertex != 1) return false;
            o_vertex[1] = v1;
            o_vertex[2] = wv1.vertex[0];
            o_vertex[3] = wv2.vertex[0];
        }
        o_vertex[4] = end_of_coord;
        return true;
    }

    private boolean getSquareLine(int[] i_mkvertex, int[] i_xcoord, int[] i_ycoord, NyARSquare o_square) throws NyARException {
        NyARLinear[] l_line = o_square.line;
        NyARDoubleMatrix22 evec = this.__getSquareLine_evec;
        NyARDoublePoint2d mean = this.__getSquareLine_mean;
        NyARDoublePoint2d ev = this.__getSquareLine_ev;
        int i = 0;
        while (i < 4) {
            double w1 = (double)(i_mkvertex[i + 1] - i_mkvertex[i] + 1) * 0.05 + 0.5;
            int ed = (int)((double)i_mkvertex[i + 1] - w1);
            int st = (int)((double)i_mkvertex[i] + w1);
            int n = ed - st + 1;
            if (n < 2) {
                return false;
            }
            this._dist_factor.observ2IdealBatch(i_xcoord, i_ycoord, st, n, this._xpos, this._ypos);
            this._pca.pca(this._xpos, this._ypos, n, evec, ev, mean);
            NyARLinear l_line_i = l_line[i];
            l_line_i.run = evec.m01;
            l_line_i.rise = -evec.m00;
            l_line_i.intercept = -(l_line_i.run * mean.x + l_line_i.rise * mean.y);
            ++i;
        }
        NyARDoublePoint2d[] l_sqvertex = o_square.sqvertex;
        NyARIntPoint[] l_imvertex = o_square.imvertex;
        int i2 = 0;
        while (i2 < 4) {
            NyARLinear l_line_i = l_line[i2];
            NyARLinear l_line_2 = l_line[(i2 + 3) % 4];
            double w1 = l_line_2.run * l_line_i.rise - l_line_i.run * l_line_2.rise;
            if (w1 == 0.0) {
                return false;
            }
            l_sqvertex[i2].x = (l_line_2.rise * l_line_i.intercept - l_line_i.rise * l_line_2.intercept) / w1;
            l_sqvertex[i2].y = (l_line_i.run * l_line_2.intercept - l_line_2.run * l_line_i.intercept) / w1;
            l_imvertex[i2].x = i_xcoord[i_mkvertex[i2]];
            l_imvertex[i2].y = i_ycoord[i_mkvertex[i2]];
            ++i2;
        }
        return true;
    }
}

