/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.types.matrix;

import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint3d;
import jp.nyatla.nyartoolkit.core.types.matrix.INyARDoubleMatrix;

public class NyARDoubleMatrix33
implements INyARDoubleMatrix {
    public double m00;
    public double m01;
    public double m02;
    public double m10;
    public double m11;
    public double m12;
    public double m20;
    public double m21;
    public double m22;

    public static NyARDoubleMatrix33[] createArray(int i_number) {
        NyARDoubleMatrix33[] ret = new NyARDoubleMatrix33[i_number];
        int i = 0;
        while (i < i_number) {
            ret[i] = new NyARDoubleMatrix33();
            ++i;
        }
        return ret;
    }

    @Override
    public void setValue(double[] i_value) {
        this.m00 = i_value[0];
        this.m01 = i_value[1];
        this.m02 = i_value[2];
        this.m10 = i_value[3];
        this.m11 = i_value[4];
        this.m12 = i_value[5];
        this.m20 = i_value[6];
        this.m21 = i_value[7];
        this.m22 = i_value[8];
    }

    public void setValue(NyARDoubleMatrix33 i_value) {
        this.m00 = i_value.m00;
        this.m01 = i_value.m01;
        this.m02 = i_value.m02;
        this.m10 = i_value.m10;
        this.m11 = i_value.m11;
        this.m12 = i_value.m12;
        this.m20 = i_value.m20;
        this.m21 = i_value.m21;
        this.m22 = i_value.m22;
    }

    @Override
    public void getValue(double[] o_value) {
        o_value[0] = this.m00;
        o_value[1] = this.m01;
        o_value[2] = this.m02;
        o_value[3] = this.m10;
        o_value[4] = this.m11;
        o_value[5] = this.m12;
        o_value[6] = this.m20;
        o_value[7] = this.m21;
        o_value[8] = this.m22;
    }

    public boolean inverse(NyARDoubleMatrix33 i_src) {
        double a11 = i_src.m00;
        double a12 = i_src.m01;
        double a13 = i_src.m02;
        double a21 = i_src.m10;
        double a22 = i_src.m11;
        double a23 = i_src.m12;
        double a31 = i_src.m20;
        double a32 = i_src.m21;
        double a33 = i_src.m22;
        double b11 = a22 * a33 - a23 * a32;
        double b12 = a32 * a13 - a33 * a12;
        double b13 = a12 * a23 - a13 * a22;
        double b21 = a23 * a31 - a21 * a33;
        double b22 = a33 * a11 - a31 * a13;
        double b23 = a13 * a21 - a11 * a23;
        double b31 = a21 * a32 - a22 * a31;
        double b32 = a31 * a12 - a32 * a11;
        double b33 = a11 * a22 - a12 * a21;
        double det_1 = a11 * b11 + a21 * b12 + a31 * b13;
        if (det_1 == 0.0) {
            return false;
        }
        det_1 = 1.0 / det_1;
        this.m00 = b11 * det_1;
        this.m01 = b12 * det_1;
        this.m02 = b13 * det_1;
        this.m10 = b21 * det_1;
        this.m11 = b22 * det_1;
        this.m12 = b23 * det_1;
        this.m20 = b31 * det_1;
        this.m21 = b32 * det_1;
        this.m22 = b33 * det_1;
        return true;
    }

    public final void getZXYAngle(NyARDoublePoint3d o_out) {
        double sina = this.m21;
        if (sina >= 1.0) {
            o_out.x = 1.5707963267948966;
            o_out.y = 0.0;
            o_out.z = Math.atan2(-this.m10, this.m00);
        } else if (sina <= -1.0) {
            o_out.x = -1.5707963267948966;
            o_out.y = 0.0;
            o_out.z = Math.atan2(-this.m10, this.m00);
        } else {
            o_out.x = Math.asin(sina);
            o_out.z = Math.atan2(-this.m01, this.m11);
            o_out.y = Math.atan2(-this.m20, this.m22);
        }
    }

    public final void setZXYAngle(NyARDoublePoint3d i_angle) {
        this.setZXYAngle(i_angle.x, i_angle.y, i_angle.z);
    }

    public final void setZXYAngle(double i_x, double i_y, double i_z) {
        double sina = Math.sin(i_x);
        double cosa = Math.cos(i_x);
        double sinb = Math.sin(i_y);
        double cosb = Math.cos(i_y);
        double sinc = Math.sin(i_z);
        double cosc = Math.cos(i_z);
        this.m00 = cosc * cosb - sinc * sina * sinb;
        this.m01 = -sinc * cosa;
        this.m02 = cosc * sinb + sinc * sina * cosb;
        this.m10 = sinc * cosb + cosc * sina * sinb;
        this.m11 = cosc * cosa;
        this.m12 = sinc * sinb - cosc * sina * cosb;
        this.m20 = -cosa * sinb;
        this.m21 = sina;
        this.m22 = cosb * cosa;
    }

    public void loadIdentity() {
        this.m22 = 1.0;
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m21 = 0.0;
        this.m20 = 0.0;
        this.m12 = 0.0;
        this.m10 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
    }

    public final void transformVertex(NyARDoublePoint3d i_position, NyARDoublePoint3d o_out) {
        this.transformVertex(i_position.x, i_position.y, i_position.z, o_out);
    }

    public final void transformVertex(double i_x, double i_y, double i_z, NyARDoublePoint3d o_out) {
        o_out.x = this.m00 * i_x + this.m01 * i_y + this.m02 * i_z;
        o_out.y = this.m10 * i_x + this.m11 * i_y + this.m12 * i_z;
        o_out.z = this.m20 * i_x + this.m21 * i_y + this.m22 * i_z;
    }

    public void mul(NyARDoubleMatrix33 i_mat_l, NyARDoubleMatrix33 i_mat_r) {
        this.m00 = i_mat_l.m00 * i_mat_r.m00 + i_mat_l.m01 * i_mat_r.m10 + i_mat_l.m02 * i_mat_r.m20;
        this.m01 = i_mat_l.m00 * i_mat_r.m01 + i_mat_l.m01 * i_mat_r.m11 + i_mat_l.m02 * i_mat_r.m21;
        this.m02 = i_mat_l.m00 * i_mat_r.m02 + i_mat_l.m01 * i_mat_r.m12 + i_mat_l.m02 * i_mat_r.m22;
        this.m10 = i_mat_l.m10 * i_mat_r.m00 + i_mat_l.m11 * i_mat_r.m10 + i_mat_l.m12 * i_mat_r.m20;
        this.m11 = i_mat_l.m10 * i_mat_r.m01 + i_mat_l.m11 * i_mat_r.m11 + i_mat_l.m12 * i_mat_r.m21;
        this.m12 = i_mat_l.m10 * i_mat_r.m02 + i_mat_l.m11 * i_mat_r.m12 + i_mat_l.m12 * i_mat_r.m22;
        this.m20 = i_mat_l.m20 * i_mat_r.m00 + i_mat_l.m21 * i_mat_r.m10 + i_mat_l.m22 * i_mat_r.m20;
        this.m21 = i_mat_l.m20 * i_mat_r.m01 + i_mat_l.m21 * i_mat_r.m11 + i_mat_l.m22 * i_mat_r.m21;
        this.m22 = i_mat_l.m20 * i_mat_r.m02 + i_mat_l.m21 * i_mat_r.m12 + i_mat_l.m22 * i_mat_r.m22;
    }
}

