/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.test;

import java.io.File;
import java.io.FileInputStream;
import java.util.Date;
import jp.nyatla.nyartoolkit.core.NyARCode;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.raster.rgb.NyARRgbRaster;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint3d;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix44;
import jp.nyatla.nyartoolkit.detector.NyARSingleDetectMarker;

public class RawFileTest {
    private final String code_file = "../Data/patt.hiro";
    private final String data_file = "../Data/320x240ABGR.raw";
    private final String camera_file = "../Data/camera_para4.dat";

    public void Test_arDetectMarkerLite() throws Exception {
        NyARParam ap = NyARParam.createFromARParamFile(new FileInputStream("../Data/camera_para4.dat"));
        ap.changeScreenSize(320, 240);
        NyARCode code = NyARCode.createFromARPattFile(new FileInputStream("../Data/patt.hiro"), 16, 16);
        File f = new File("../Data/320x240ABGR.raw");
        FileInputStream fs = new FileInputStream("../Data/320x240ABGR.raw");
        byte[] buf = new byte[(int)f.length()];
        fs.read(buf);
        NyARRgbRaster ra = new NyARRgbRaster(320, 240, 65793, false);
        ra.wrapBuffer(buf);
        NyARSingleDetectMarker ar = NyARSingleDetectMarker.createInstance(ap, code, 80.0, 2);
        NyARDoubleMatrix44 result_mat = new NyARDoubleMatrix44();
        ar.setContinueMode(true);
        ar.detectMarkerLite(ra, 100);
        ar.getTransmat(result_mat);
        Date d2 = new Date();
        int i = 0;
        while (i < 1000) {
            ar.detectMarkerLite(ra, 100);
            ++i;
        }
        Date d = new Date();
        NyARDoublePoint3d ang = new NyARDoublePoint3d();
        result_mat.getZXYAngle(ang);
        System.out.println(d.getTime() - d2.getTime());
        System.out.print(ar.getConfidence());
    }

    public static void main(String[] args) {
        try {
            RawFileTest t = new RawFileTest();
            t.Test_arDetectMarkerLite();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

