/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.squaredetect;

import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;

final class NyARVertexCounter {
    public final int[] vertex = new int[10];
    public int number_of_vertex;
    private double thresh;
    private NyARIntPoint2d[] _coord;

    NyARVertexCounter() {
    }

    public boolean getVertex(NyARIntPoint2d[] i_coord, int i_coord_len, int st, int ed, double i_thresh) {
        this.number_of_vertex = 0;
        this.thresh = i_thresh;
        this._coord = i_coord;
        return this.get_vertex(st, ed, i_coord_len);
    }

    private boolean get_vertex(int st, int ed, int i_coord_len) {
        int v1 = 0;
        NyARIntPoint2d[] coord = this._coord;
        int a = coord[ed].y - coord[st].y;
        int b = coord[st].x - coord[ed].x;
        int c = coord[ed].x * coord[st].y - coord[ed].y * coord[st].x;
        double dmax = 0.0;
        if (st < ed) {
            int i = st + 1;
            while (i < ed) {
                double d = a * coord[i].x + b * coord[i].y + c;
                if (d * d > dmax) {
                    dmax = d * d;
                    v1 = i;
                }
                ++i;
            }
        } else {
            double d;
            int i = st + 1;
            while (i < i_coord_len) {
                d = a * coord[i].x + b * coord[i].y + c;
                if (d * d > dmax) {
                    dmax = d * d;
                    v1 = i;
                }
                ++i;
            }
            i = 0;
            while (i < ed) {
                d = a * coord[i].x + b * coord[i].y + c;
                if (d * d > dmax) {
                    dmax = d * d;
                    v1 = i;
                }
                ++i;
            }
        }
        if (dmax / (double)(a * a + b * b) > this.thresh) {
            if (!this.get_vertex(st, v1, i_coord_len)) {
                return false;
            }
            if (this.number_of_vertex > 5) {
                return false;
            }
            this.vertex[this.number_of_vertex] = v1;
            ++this.number_of_vertex;
            if (!this.get_vertex(v1, ed, i_coord_len)) {
                return false;
            }
        }
        return true;
    }
}

