/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.squaredetect;

final class NyARVertexCounter {
    public final int[] vertex = new int[10];
    public int number_of_vertex;
    private double thresh;
    private int[] x_coord;
    private int[] y_coord;

    NyARVertexCounter() {
    }

    public boolean getVertex(int[] i_x_coord, int[] i_y_coord, int i_coord_len, int st, int ed, double i_thresh) {
        this.number_of_vertex = 0;
        this.thresh = i_thresh;
        this.x_coord = i_x_coord;
        this.y_coord = i_y_coord;
        return this.get_vertex(st, ed, i_coord_len);
    }

    private boolean get_vertex(int st, int ed, int i_coord_len) {
        int v1 = 0;
        int[] lx_coord = this.x_coord;
        int[] ly_coord = this.y_coord;
        int a = ly_coord[ed] - ly_coord[st];
        int b = lx_coord[st] - lx_coord[ed];
        int c = lx_coord[ed] * ly_coord[st] - ly_coord[ed] * lx_coord[st];
        double dmax = 0.0;
        if (st < ed) {
            int i = st + 1;
            while (i < ed) {
                double d = a * lx_coord[i] + b * ly_coord[i] + c;
                if (d * d > dmax) {
                    dmax = d * d;
                    v1 = i;
                }
                ++i;
            }
        } else {
            double d;
            int i = st + 1;
            while (i < i_coord_len) {
                d = a * lx_coord[i] + b * ly_coord[i] + c;
                if (d * d > dmax) {
                    dmax = d * d;
                    v1 = i;
                }
                ++i;
            }
            i = 0;
            while (i < ed) {
                d = a * lx_coord[i] + b * ly_coord[i] + c;
                if (d * d > dmax) {
                    dmax = d * d;
                    v1 = i;
                }
                ++i;
            }
        }
        if (dmax / (double)(a * a + b * b) > this.thresh) {
            if (!this.get_vertex(st, v1, i_coord_len)) {
                return false;
            }
            if (this.number_of_vertex > 5) {
                return false;
            }
            this.vertex[this.number_of_vertex] = v1;
            ++this.number_of_vertex;
            if (!this.get_vertex(v1, ed, i_coord_len)) {
                return false;
            }
        }
        return true;
    }
}

