/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.pickup;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.pickup.INyARColorPatt;
import jp.nyatla.nyartoolkit.core.pixeldriver.INyARRgbPixelDriver;
import jp.nyatla.nyartoolkit.core.pixeldriver.NyARRgbPixelDriverFactory;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix44;

public class NyARColorPatt_PseudoAffine
implements INyARColorPatt {
    private int[] _patdata;
    private INyARRgbPixelDriver _pixelreader;
    private NyARIntSize _size;
    private static final int BUFFER_FORMAT = 262402;
    private NyARDoubleMatrix44 _invmat = new NyARDoubleMatrix44();
    private double[] _convparam = new double[8];

    @Override
    public final int getWidth() {
        return this._size.w;
    }

    @Override
    public final int getHeight() {
        return this._size.h;
    }

    @Override
    public final NyARIntSize getSize() {
        return this._size;
    }

    @Override
    public final INyARRgbPixelDriver getRgbPixelDriver() {
        return this._pixelreader;
    }

    @Override
    public Object getBuffer() {
        return this._patdata;
    }

    @Override
    public boolean hasBuffer() {
        return this._patdata != null;
    }

    @Override
    public void wrapBuffer(Object i_ref_buf) throws NyARException {
        NyARException.notImplement();
    }

    @Override
    public final int getBufferType() {
        return 262402;
    }

    @Override
    public final boolean isEqualBufferType(int i_type_value) {
        return 262402 == i_type_value;
    }

    public NyARColorPatt_PseudoAffine(int i_width, int i_height) throws NyARException {
        this._size = new NyARIntSize(i_width, i_height);
        this._patdata = new int[i_height * i_width];
        this._pixelreader = NyARRgbPixelDriverFactory.createDriver(this);
        NyARDoubleMatrix44 mat = this._invmat;
        mat.m00 = 0.0;
        mat.m01 = 0.0;
        mat.m02 = 0.0;
        mat.m03 = 1.0;
        mat.m10 = 0.0;
        mat.m11 = i_width - 1;
        mat.m12 = 0.0;
        mat.m13 = 1.0;
        mat.m20 = (i_width - 1) * (i_height - 1);
        mat.m21 = i_width - 1;
        mat.m22 = i_height - 1;
        mat.m23 = 1.0;
        mat.m30 = 0.0;
        mat.m31 = 0.0;
        mat.m32 = i_height - 1;
        mat.m33 = 1.0;
        mat.inverse(mat);
    }

    private void calcPara(NyARIntPoint2d[] i_vertex, double[] o_cparam) {
        NyARDoubleMatrix44 invmat = this._invmat;
        double v1 = i_vertex[0].x;
        double v2 = i_vertex[1].x;
        double v4 = i_vertex[3].x;
        o_cparam[0] = invmat.m00 * v1 + invmat.m01 * v2 + invmat.m02 * (double)i_vertex[2].x + invmat.m03 * v4;
        o_cparam[1] = invmat.m10 * v1 + invmat.m11 * v2;
        o_cparam[2] = invmat.m20 * v1 + invmat.m23 * v4;
        o_cparam[3] = v1;
        v1 = i_vertex[0].y;
        v2 = i_vertex[1].y;
        v4 = i_vertex[3].y;
        o_cparam[4] = invmat.m00 * v1 + invmat.m01 * v2 + invmat.m02 * (double)i_vertex[2].y + invmat.m03 * v4;
        o_cparam[5] = invmat.m10 * v1 + invmat.m11 * v2;
        o_cparam[6] = invmat.m20 * v1 + invmat.m23 * v4;
        o_cparam[7] = v1;
    }

    @Override
    public boolean pickFromRaster(INyARRgbRaster image, NyARIntPoint2d[] i_vertexs) throws NyARException {
        double[] conv_param = this._convparam;
        int rx2 = this._size.w;
        int ry2 = this._size.h;
        int[] rgb_tmp = new int[3];
        INyARRgbPixelDriver reader = image.getRgbPixelDriver();
        this.calcPara(i_vertexs, conv_param);
        int y = 0;
        while (y < ry2) {
            int x = 0;
            while (x < rx2) {
                int ttx = (int)(conv_param[0] * (double)x * (double)y + conv_param[1] * (double)x + conv_param[2] * (double)y + conv_param[3] + 0.5);
                int tty = (int)(conv_param[4] * (double)x * (double)y + conv_param[5] * (double)x + conv_param[6] * (double)y + conv_param[7] + 0.5);
                reader.getPixel(ttx, tty, rgb_tmp);
                this._patdata[x + y * rx2] = rgb_tmp[0] << 16 | rgb_tmp[1] << 8 | rgb_tmp[2];
                ++x;
            }
            ++y;
        }
        return true;
    }

    @Override
    public Object createInterface(Class<?> iIid) throws NyARException {
        return null;
    }
}

