/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.pixeldriver;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.pixeldriver.INyARGsPixelDriver;
import jp.nyatla.nyartoolkit.core.pixeldriver.INyARRgbPixelDriver;
import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

class NyARGsPixelDriver_RGBX
implements INyARGsPixelDriver {
    private INyARRgbPixelDriver _rgbd;
    private int[] _tmp = new int[3];

    public NyARGsPixelDriver_RGBX(INyARRgbRaster i_raster) throws NyARException {
        this._rgbd = i_raster.getRgbPixelDriver();
    }

    @Override
    public NyARIntSize getSize() {
        return this._rgbd.getSize();
    }

    @Override
    public void getPixelSet(int[] i_x, int[] i_y, int i_n, int[] o_buf, int i_st_buf) throws NyARException {
        INyARRgbPixelDriver r = this._rgbd;
        int[] tmp = this._tmp;
        int i = i_n - 1;
        while (i >= 0) {
            r.getPixel(i_x[i], i_y[i], tmp);
            o_buf[i_st_buf + i] = (tmp[0] + tmp[1] + tmp[2]) / 3;
            --i;
        }
    }

    @Override
    public int getPixel(int i_x, int i_y) throws NyARException {
        int[] tmp = this._tmp;
        this._rgbd.getPixel(i_x, i_y, tmp);
        return (tmp[0] + tmp[1] + tmp[2]) / 3;
    }

    @Override
    public void setPixel(int i_x, int i_y, int i_gs) throws NyARException {
        this._rgbd.setPixel(i_x, i_y, i_gs, i_gs, i_gs);
    }

    @Override
    public void setPixels(int[] i_x, int[] i_y, int i_num, int[] i_intgs) throws NyARException {
        INyARRgbPixelDriver r = this._rgbd;
        int i = i_num - 1;
        while (i >= 0) {
            int gs = i_intgs[i];
            r.setPixel(i_x[i], i_y[i], gs, gs, gs);
            --i;
        }
    }

    @Override
    public void switchRaster(INyARRaster i_ref_raster) throws NyARException {
        if (!(i_ref_raster instanceof INyARRgbRaster)) {
            throw new NyARException();
        }
        this._rgbd = ((INyARRgbRaster)i_ref_raster).getRgbPixelDriver();
    }

    @Override
    public boolean isCompatibleRaster(INyARRaster i_raster) {
        return i_raster instanceof INyARRgbRaster;
    }
}

