/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.types;

import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;

public class NyARIntPoint2d {
    public int x;
    public int y;

    public static NyARIntPoint2d[] createArray(int i_number) {
        NyARIntPoint2d[] ret = new NyARIntPoint2d[i_number];
        int i = 0;
        while (i < i_number) {
            ret[i] = new NyARIntPoint2d();
            ++i;
        }
        return ret;
    }

    public static void copyArray(NyARIntPoint2d[] i_from, NyARIntPoint2d[] i_to) {
        int i = i_from.length - 1;
        while (i >= 0) {
            i_to[i].x = i_from[i].x;
            i_to[i].y = i_from[i].y;
            --i;
        }
    }

    public static void shiftCopy(NyARDoublePoint2d[] i_src, NyARIntPoint2d[] i_dst, int i_shift) {
        int l = i_src.length;
        int i = l - 1;
        while (i >= 0) {
            int n = (i + i_shift) % l;
            i_dst[i].x = (int)i_src[n].x;
            i_dst[i].y = (int)i_src[n].y;
            --i;
        }
    }

    public static void shiftCopy(NyARIntPoint2d[] i_src, NyARIntPoint2d[] i_dst, int i_shift) {
        int l = i_src.length;
        int i = l - 1;
        while (i >= 0) {
            int n = (i + i_shift) % l;
            i_dst[i].x = i_src[n].x;
            i_dst[i].y = i_src[n].y;
            --i;
        }
    }

    public static void makeCenter(NyARIntPoint2d[] i_points, int i_number_of_data, NyARIntPoint2d o_out) {
        o_out.setCenterPos(i_points, i_number_of_data);
    }

    public final int sqDist(NyARIntPoint2d i_p1) {
        int x = this.x - i_p1.x;
        int y = this.y - i_p1.y;
        return x * x + y * y;
    }

    public final void setCenterPos(NyARIntPoint2d[] i_point, int i_number_of_vertex) {
        int cy = 0;
        int cx = 0;
        int i = i_number_of_vertex - 1;
        while (i >= 0) {
            cx += i_point[i].x;
            cy += i_point[i].y;
            --i;
        }
        this.x = cx / i_number_of_vertex;
        this.y = cy / i_number_of_vertex;
    }

    public final void setValue(NyARIntPoint2d i_source) {
        this.x = i_source.x;
        this.y = i_source.y;
    }

    public final void setValue(NyARDoublePoint2d i_source) {
        this.x = (int)i_source.x;
        this.y = (int)i_source.y;
    }

    public final void setValue(int i_x, int i_y) {
        this.x = i_x;
        this.y = i_y;
    }
}

