/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterfilter.rgb2gs;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.pixeldriver.INyARGsPixelDriver;
import jp.nyatla.nyartoolkit.core.raster.INyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.rgb2gs.INyARRgb2GsFilterRgbAve;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

class NyARRgb2GsFilterRgbAve_INT1D_X8R8G8B8_32
implements INyARRgb2GsFilterRgbAve {
    private INyARRaster _ref_raster;

    public NyARRgb2GsFilterRgbAve_INT1D_X8R8G8B8_32(INyARRaster i_ref_raster) {
        assert (i_ref_raster.isEqualBufferType(262402));
        this._ref_raster = i_ref_raster;
    }

    @Override
    public void convert(INyARGrayscaleRaster i_raster) throws NyARException {
        NyARIntSize s = this._ref_raster.getSize();
        this.convertRect(0, 0, s.w, s.h, i_raster);
    }

    @Override
    public void convertRect(int l, int t, int w, int h, INyARGrayscaleRaster o_raster) throws NyARException {
        int row_padding_dst;
        NyARIntSize size = this._ref_raster.getSize();
        int bp = l + t * size.w;
        int b = t + h;
        int row_padding_src = row_padding_dst = size.w - w;
        int pix_count = w;
        int pix_mod_part = pix_count - pix_count % 8;
        int src_ptr = t * size.w + l;
        int[] in_buf = (int[])this._ref_raster.getBuffer();
        switch (o_raster.getBufferType()) {
            case 262145: {
                int[] out_buf = (int[])o_raster.getBuffer();
                int y = t;
                while (y < b) {
                    int v;
                    int x = 0;
                    x = pix_count - 1;
                    while (x >= pix_mod_part) {
                        v = in_buf[src_ptr++];
                        out_buf[bp++] = (v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF) >> 2;
                        --x;
                    }
                    while (x >= 0) {
                        v = in_buf[src_ptr++];
                        out_buf[bp++] = ((v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF)) / 3;
                        v = in_buf[src_ptr++];
                        out_buf[bp++] = ((v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF)) / 3;
                        v = in_buf[src_ptr++];
                        out_buf[bp++] = ((v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF)) / 3;
                        v = in_buf[src_ptr++];
                        out_buf[bp++] = ((v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF)) / 3;
                        v = in_buf[src_ptr++];
                        out_buf[bp++] = ((v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF)) / 3;
                        v = in_buf[src_ptr++];
                        out_buf[bp++] = ((v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF)) / 3;
                        v = in_buf[src_ptr++];
                        out_buf[bp++] = ((v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF)) / 3;
                        v = in_buf[src_ptr++];
                        out_buf[bp++] = ((v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF)) / 3;
                        x -= 8;
                    }
                    bp += row_padding_dst;
                    src_ptr += row_padding_src;
                    ++y;
                }
                return;
            }
        }
        INyARGsPixelDriver out_drv = o_raster.getGsPixelDriver();
        int y = t;
        while (y < b) {
            int x = 0;
            while (x < pix_count) {
                int v = in_buf[src_ptr++];
                out_drv.setPixel(x, y, ((v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF)) / 3);
                ++x;
            }
            ++y;
        }
    }
}

