/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.squaredetect;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.labeling.NyARLabelOverlapChecker;
import jp.nyatla.nyartoolkit.core.labeling.rlelabeling.NyARLabeling_Rle;
import jp.nyatla.nyartoolkit.core.labeling.rlelabeling.NyARRleLabelFragmentInfoStack;
import jp.nyatla.nyartoolkit.core.param.NyARCameraDistortionFactor;
import jp.nyatla.nyartoolkit.core.raster.NyARBinRaster;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARContourPickup;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARCoord2SquareVertexIndexes;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquareContourDetector;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARSquareContourDetector_Rle
extends NyARSquareContourDetector {
    private static final int AR_AREA_MAX = 100000;
    private static final int AR_AREA_MIN = 70;
    private final int _width;
    private final int _height;
    private final NyARLabeling_Rle _labeling;
    private final NyARLabelOverlapChecker<NyARRleLabelFragmentInfoStack.RleLabelFragmentInfo> _overlap_checker = new NyARLabelOverlapChecker<NyARRleLabelFragmentInfoStack.RleLabelFragmentInfo>(32, NyARRleLabelFragmentInfoStack.RleLabelFragmentInfo.class);
    private final NyARContourPickup _cpickup = new NyARContourPickup();
    private final NyARRleLabelFragmentInfoStack _stack;
    private final NyARCoord2SquareVertexIndexes _coord2vertex = new NyARCoord2SquareVertexIndexes();
    private final int _max_coord;
    private final int[] _xcoord;
    private final int[] _ycoord;
    private final int[] __detectMarker_mkvertex = new int[4];

    public NyARSquareContourDetector_Rle(NyARCameraDistortionFactor i_dist_factor_ref, NyARIntSize i_size) throws NyARException {
        int number_of_coord;
        this._width = i_size.w;
        this._height = i_size.h;
        this._labeling = new NyARLabeling_Rle(this._width, this._height);
        this._labeling.setAreaRange(100000, 70);
        this._stack = new NyARRleLabelFragmentInfoStack(i_size.w * i_size.h * 2048 / 76800 + 32);
        this._max_coord = number_of_coord = (this._width + this._height) * 2;
        this._xcoord = new int[number_of_coord];
        this._ycoord = new int[number_of_coord];
    }

    public void detectMarkerCB(NyARBinRaster i_raster, NyARSquareContourDetector.IDetectMarkerCallback i_callback) throws NyARException {
        NyARRleLabelFragmentInfoStack flagment = this._stack;
        NyARLabelOverlapChecker<NyARRleLabelFragmentInfoStack.RleLabelFragmentInfo> overlap = this._overlap_checker;
        int label_num = this._labeling.labeling(i_raster, 0, i_raster.getHeight(), flagment);
        if (label_num < 1) {
            return;
        }
        flagment.sortByArea();
        NyARRleLabelFragmentInfoStack.RleLabelFragmentInfo[] labels = (NyARRleLabelFragmentInfoStack.RleLabelFragmentInfo[])flagment.getArray();
        int xsize = this._width;
        int ysize = this._height;
        int[] xcoord = this._xcoord;
        int[] ycoord = this._ycoord;
        int coord_max = this._max_coord;
        int[] mkvertex = this.__detectMarker_mkvertex;
        overlap.setMaxLabels(label_num);
        int i = 0;
        while (i < label_num) {
            int coord_num;
            NyARRleLabelFragmentInfoStack.RleLabelFragmentInfo label_pt = labels[i];
            int label_area = label_pt.area;
            if (label_pt.clip_l != 0 && label_pt.clip_r != xsize - 1 && label_pt.clip_t != 0 && label_pt.clip_b != ysize - 1 && overlap.check(label_pt) && (coord_num = this._cpickup.getContour(i_raster, label_pt.entry_x, label_pt.clip_t, coord_max, xcoord, ycoord)) != coord_max && this._coord2vertex.getVertexIndexes(xcoord, ycoord, coord_num, label_area, mkvertex)) {
                i_callback.onSquareDetect(this, xcoord, ycoord, coord_num, mkvertex);
                overlap.push(label_pt);
            }
            ++i;
        }
    }

    public NyARRleLabelFragmentInfoStack _getFragmentStack() {
        return this._stack;
    }
}

