/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterreader;

import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARVectorReader_INT1D_GRAY_8 {
    private int[] _ref_buf;
    private NyARIntSize _ref_size;

    public NyARVectorReader_INT1D_GRAY_8(INyARRaster i_ref_raster) {
        assert (i_ref_raster.getBufferType() == 262145);
        this._ref_buf = (int[])i_ref_raster.getBuffer();
        this._ref_size = i_ref_raster.getSize();
    }

    public void getPixelVector4(int x, int y, NyARIntPoint2d o_v) {
        int[] buf = this._ref_buf;
        int w = this._ref_size.w;
        int idx = w * y + x;
        o_v.x = buf[idx + 1] - buf[idx - 1];
        o_v.y = buf[idx + w] - buf[idx - w];
    }

    public void getPixelVector8(int x, int y, NyARIntPoint2d o_v) {
        int[] buf = this._ref_buf;
        NyARIntSize s = this._ref_size;
        int idx_0 = s.w * y + x;
        int idx_p1 = idx_0 + s.w;
        int idx_m1 = idx_0 - s.w;
        int b = buf[idx_m1 - 1];
        int d = buf[idx_m1 + 1];
        int h = buf[idx_p1 - 1];
        int f = buf[idx_p1 + 1];
        o_v.x = buf[idx_0 + 1] - buf[idx_0 - 1] + (d - b + f - h) / 2;
        o_v.y = buf[idx_p1] - buf[idx_m1] + (f - d + h - b) / 2;
    }
}

