/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyar4psg;

import jp.nyatla.nyar4psg.NyAR4PsgConfig;
import jp.nyatla.nyar4psg.PImageRaster;
import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.param.NyARFrustum;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.param.NyARPerspectiveProjectionMatrix;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterreader.NyARPerspectiveRasterReader;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMatResult;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint3d;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix44;
import processing.core.PApplet;
import processing.core.PGraphics3D;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix3D;
import processing.core.PVector;

class NyARPsgBaseClass {
    public static final String VERSION = "NyAR4psg/1.0.3;NyARToolkit for java/3.0.0+;ARToolKit/2.72.1";
    protected PApplet _ref_papplet;
    protected final PMatrix3D _ps_projection = new PMatrix3D();
    protected final NyARParam _ar_param = new NyARParam();
    protected final NyARFrustum _frustum = new NyARFrustum();
    protected NyAR4PsgConfig _config;
    protected PImageRaster _src_raster;
    protected NyARPerspectiveRasterReader _preader;
    private static final float view_distance_min = 100.0f;
    private static final float view_distance_max = 100000.0f;
    private static final PMatrix3D _lh_mat = new PMatrix3D(-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);

    protected NyARPsgBaseClass() {
    }

    protected void initInstance(PApplet parent, String i_cparam_file, int i_width, int i_height, NyAR4PsgConfig i_config) throws NyARException {
        this._ref_papplet = parent;
        this._config = i_config;
        this._src_raster = new PImageRaster(i_width, i_height);
        this._preader = new NyARPerspectiveRasterReader(this._src_raster.getBufferType());
        try {
            this._ar_param.loadARParam(this._ref_papplet.createInput(i_cparam_file));
            this._ar_param.changeScreenSize(i_width, i_height);
            NyARPsgBaseClass.arPerspectiveMat2Projection(this._ar_param.getPerspectiveProjectionMatrix(), i_width, i_height, this._ps_projection, this._frustum);
        }
        catch (NyARException e) {
            this._ref_papplet.die("Error while setting up NyARToolkit for java", (Exception)((Object)e));
        }
    }

    public PMatrix3D setARPerspective() {
        return this.setPerspective(this._ps_projection);
    }

    public PMatrix3D setPerspective(PMatrix3D i_projection) {
        if (!(this._ref_papplet.g instanceof PGraphics3D)) {
            this._ref_papplet.die("NyAR4Psg require PGraphics3D instance.");
        }
        PGraphics3D g = (PGraphics3D)this._ref_papplet.g;
        PMatrix3D ret = new PMatrix3D();
        ret.set((PMatrix)g.projection);
        float far = i_projection.m23 / (i_projection.m22 + 1.0f);
        float near = i_projection.m23 / (i_projection.m22 - 1.0f);
        this._ref_papplet.frustum((i_projection.m02 - 1.0f) * near / i_projection.m00, (i_projection.m02 + 1.0f) * near / i_projection.m00, (i_projection.m12 - 1.0f) * near / i_projection.m11, (i_projection.m12 + 1.0f) * near / i_projection.m11, near, far);
        return ret;
    }

    protected static void PMatrix2GLProjection(PMatrix3D i_in, float[] o_out) {
        o_out[0] = i_in.m00;
        o_out[1] = i_in.m10;
        o_out[2] = i_in.m20;
        o_out[3] = i_in.m30;
        o_out[4] = i_in.m01;
        o_out[5] = i_in.m11;
        o_out[6] = i_in.m21;
        o_out[7] = i_in.m31;
        o_out[8] = i_in.m02;
        o_out[9] = i_in.m12;
        o_out[10] = i_in.m22;
        o_out[11] = i_in.m32;
        o_out[12] = i_in.m03;
        o_out[13] = i_in.m13;
        o_out[14] = i_in.m23;
        o_out[15] = i_in.m33;
    }

    protected static void PMatrix2GLProjection(PMatrix3D i_in, double[] o_out) {
        o_out[0] = i_in.m00;
        o_out[1] = i_in.m10;
        o_out[2] = i_in.m20;
        o_out[3] = i_in.m30;
        o_out[4] = i_in.m01;
        o_out[5] = i_in.m11;
        o_out[6] = i_in.m21;
        o_out[7] = i_in.m31;
        o_out[8] = i_in.m02;
        o_out[9] = i_in.m12;
        o_out[10] = i_in.m22;
        o_out[11] = i_in.m32;
        o_out[12] = i_in.m03;
        o_out[13] = i_in.m13;
        o_out[14] = i_in.m23;
        o_out[15] = i_in.m33;
    }

    private static void arPerspectiveMat2Projection(NyARPerspectiveProjectionMatrix i_prjmat, int i_w, int i_h, PMatrix3D o_projection, NyARFrustum o_frustum) {
        NyARDoubleMatrix44 tmp = new NyARDoubleMatrix44();
        i_prjmat.makeCameraFrustumRH((double)i_w, (double)i_h, 100.0, 100000.0, tmp);
        o_projection.m00 = (float)tmp.m00;
        o_projection.m01 = (float)tmp.m01;
        o_projection.m02 = (float)tmp.m02;
        o_projection.m03 = (float)tmp.m03;
        o_projection.m10 = (float)tmp.m10;
        o_projection.m11 = (float)tmp.m11;
        o_projection.m12 = (float)tmp.m12;
        o_projection.m13 = (float)tmp.m13;
        o_projection.m20 = (float)tmp.m20;
        o_projection.m21 = (float)tmp.m21;
        o_projection.m22 = (float)tmp.m22;
        o_projection.m23 = (float)tmp.m23;
        o_projection.m30 = (float)tmp.m30;
        o_projection.m31 = (float)tmp.m31;
        o_projection.m32 = (float)tmp.m32;
        o_projection.m33 = (float)tmp.m33;
        o_frustum.setValue(tmp, i_w, i_h);
    }

    protected static void matResult2GLArray(NyARTransMatResult i_src, double[] o_gl_array) {
        o_gl_array[0] = i_src.m00;
        o_gl_array[4] = i_src.m01;
        o_gl_array[8] = i_src.m02;
        o_gl_array[12] = i_src.m03;
        o_gl_array[1] = -i_src.m10;
        o_gl_array[5] = -i_src.m11;
        o_gl_array[9] = -i_src.m12;
        o_gl_array[13] = -i_src.m13;
        o_gl_array[2] = -i_src.m20;
        o_gl_array[6] = -i_src.m21;
        o_gl_array[10] = -i_src.m22;
        o_gl_array[14] = -i_src.m23;
        o_gl_array[3] = 0.0;
        o_gl_array[7] = 0.0;
        o_gl_array[11] = 0.0;
        o_gl_array[15] = 1.0;
    }

    protected static void matResult2PMatrix3D(NyARDoubleMatrix44 i_src, int i_mode, PMatrix3D o_pmatrix) {
        o_pmatrix.m00 = (float)i_src.m00;
        o_pmatrix.m01 = (float)i_src.m01;
        o_pmatrix.m02 = (float)i_src.m02;
        o_pmatrix.m03 = (float)i_src.m03;
        o_pmatrix.m10 = (float)i_src.m10;
        o_pmatrix.m11 = (float)i_src.m11;
        o_pmatrix.m12 = (float)i_src.m12;
        o_pmatrix.m13 = (float)i_src.m13;
        o_pmatrix.m20 = (float)(-i_src.m20);
        o_pmatrix.m21 = (float)(-i_src.m21);
        o_pmatrix.m22 = (float)(-i_src.m22);
        o_pmatrix.m23 = (float)(-i_src.m23);
        o_pmatrix.m30 = 0.0f;
        o_pmatrix.m31 = 0.0f;
        o_pmatrix.m32 = 0.0f;
        o_pmatrix.m33 = 1.0f;
        if (i_mode == 1) {
            o_pmatrix.apply(_lh_mat);
        }
    }

    protected PVector screen2MarkerCoordSystem(NyARDoubleMatrix44 i_mat, int i_x, int i_y) {
        PVector ret = new PVector();
        NyARDoublePoint3d tmp = new NyARDoublePoint3d();
        this._frustum.unProjectOnMatrix((double)i_x, (double)i_y, i_mat, tmp);
        ret.x = (float)tmp.x;
        ret.y = (float)tmp.y;
        ret.z = (float)tmp.z;
        if (this._config._coordinate_system == 1) {
            ret.x *= -1.0f;
        }
        return ret;
    }

    protected PImage pickupMarkerImage(NyARDoubleMatrix44 i_mat, int i_x1, int i_y1, int i_x2, int i_y2, int i_x3, int i_y3, int i_x4, int i_y4, int i_out_w_pix, int i_out_h_pix) {
        if (!this._src_raster.hasBuffer()) {
            this._ref_papplet.die("_rel_detector is null.(Function detect() was never called. )");
        }
        PImage img = new PImage(i_out_w_pix, i_out_h_pix);
        img.parent = this._ref_papplet;
        try {
            NyARDoublePoint3d[] pos = NyARDoublePoint3d.createArray((int)4);
            i_mat.transform3d((double)i_x1, (double)i_y1, 0.0, pos[1]);
            i_mat.transform3d((double)i_x2, (double)i_y2, 0.0, pos[0]);
            i_mat.transform3d((double)i_x3, (double)i_y3, 0.0, pos[3]);
            i_mat.transform3d((double)i_x4, (double)i_y4, 0.0, pos[2]);
            NyARDoublePoint2d[] pos2 = NyARDoublePoint2d.createArray((int)4);
            int i = 3;
            while (i >= 0) {
                this._frustum.project(pos[i], pos2[i]);
                --i;
            }
            PImageRaster out_raster = new PImageRaster(i_out_w_pix, i_out_h_pix);
            out_raster.wrapBuffer(img);
            if (!this._preader.read4Point((INyARRgbRaster)this._src_raster, pos2, 0, 0, 1, (INyARRgbRaster)out_raster)) {
                throw new Exception("this._preader.read4Point failed.");
            }
            return img;
        }
        catch (Exception e) {
            e.printStackTrace();
            this._ref_papplet.die("Exception occurred at MultiARTookitMarker.pickupImage");
            return null;
        }
    }
}

