/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterfilter;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.INyARRasterFilter;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARRasterFilter_Roberts
implements INyARRasterFilter {
    private IdoFilterImpl _do_filter_impl;

    public NyARRasterFilter_Roberts(int i_raster_type) throws NyARException {
        switch (i_raster_type) {
            case 262145: {
                this._do_filter_impl = new IdoFilterImpl_GRAY_8();
                break;
            }
            default: {
                throw new NyARException();
            }
        }
    }

    @Override
    public void doFilter(INyARRaster i_input, INyARRaster i_output) throws NyARException {
        this._do_filter_impl.doFilter(i_input, i_output, i_input.getSize());
    }

    protected static interface IdoFilterImpl {
        public void doFilter(INyARRaster var1, INyARRaster var2, NyARIntSize var3) throws NyARException;
    }

    private class IdoFilterImpl_GRAY_8
    implements IdoFilterImpl {
        private IdoFilterImpl_GRAY_8() {
        }

        @Override
        public void doFilter(INyARRaster i_input, INyARRaster i_output, NyARIntSize i_size) throws NyARException {
            assert (i_input.isEqualBufferType(262145));
            assert (i_output.isEqualBufferType(262145));
            int[] in_ptr = (int[])i_input.getBuffer();
            int[] out_ptr = (int[])i_output.getBuffer();
            int width = i_size.w;
            int idx = 0;
            int idx2 = width;
            int mod_p = width - 2 - (width - 2) % 8;
            int y = i_size.h - 2;
            while (y >= 0) {
                int fy;
                int fx;
                int p11;
                int p01;
                int p00 = in_ptr[idx++];
                int p10 = in_ptr[idx2++];
                int x = width - 2;
                while (x >= mod_p) {
                    p01 = in_ptr[idx++];
                    p11 = in_ptr[idx2++];
                    fx = p11 - p00;
                    fy = p10 - p01;
                    out_ptr[idx - 2] = (fx < 0 ? -fx : fx) + (fy < 0 ? -fy : fy) >> 1;
                    p00 = p01;
                    p10 = p11;
                    --x;
                }
                while (x >= 0) {
                    p01 = in_ptr[idx++];
                    p11 = in_ptr[idx2++];
                    fx = p11 - p00;
                    fy = p10 - p01;
                    out_ptr[idx - 2] = (fx < 0 ? -fx : fx) + (fy < 0 ? -fy : fy) >> 1;
                    p00 = p01;
                    p10 = p11;
                    p01 = in_ptr[idx++];
                    p11 = in_ptr[idx2++];
                    fx = p11 - p00;
                    fy = p10 - p01;
                    out_ptr[idx - 2] = (fx < 0 ? -fx : fx) + (fy < 0 ? -fy : fy) >> 1;
                    p00 = p01;
                    p10 = p11;
                    p01 = in_ptr[idx++];
                    p11 = in_ptr[idx2++];
                    fx = p11 - p00;
                    fy = p10 - p01;
                    out_ptr[idx - 2] = (fx < 0 ? -fx : fx) + (fy < 0 ? -fy : fy) >> 1;
                    p00 = p01;
                    p10 = p11;
                    p01 = in_ptr[idx++];
                    p11 = in_ptr[idx2++];
                    fx = p11 - p00;
                    fy = p10 - p01;
                    out_ptr[idx - 2] = (fx < 0 ? -fx : fx) + (fy < 0 ? -fy : fy) >> 1;
                    p00 = p01;
                    p10 = p11;
                    x -= 4;
                }
                out_ptr[idx - 1] = 0;
                --y;
            }
            int x = width - 1;
            while (x >= 0) {
                out_ptr[idx++] = 0;
                --x;
            }
        }
    }
}

