/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterfilter.gs;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.gs.INyARGsRobertsFilter;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

class NyARGsRobertsFilter_GS8
implements INyARGsRobertsFilter {
    private INyARGrayscaleRaster _raster;

    public NyARGsRobertsFilter_GS8(INyARGrayscaleRaster i_raster) {
        this._raster = i_raster;
    }

    @Override
    public void doFilter(INyARGrayscaleRaster i_output) throws NyARException {
        assert (i_output.isEqualBufferType(262145));
        NyARIntSize size = this._raster.getSize();
        int[] in_ptr = (int[])this._raster.getBuffer();
        switch (this._raster.getBufferType()) {
            case 262145: {
                int[] out_ptr = (int[])i_output.getBuffer();
                int width = size.w;
                int idx = 0;
                int idx2 = width;
                int mod_p = width - 2 - (width - 2) % 8;
                int y = size.h - 2;
                while (y >= 0) {
                    int fy;
                    int fx;
                    int p11;
                    int p01;
                    int p00 = in_ptr[idx++];
                    int p10 = in_ptr[idx2++];
                    int x = width - 2;
                    while (x >= mod_p) {
                        p01 = in_ptr[idx++];
                        p11 = in_ptr[idx2++];
                        fx = p11 - p00;
                        fy = p10 - p01;
                        out_ptr[idx - 2] = (fx < 0 ? -fx : fx) + (fy < 0 ? -fy : fy) >> 1;
                        p00 = p01;
                        p10 = p11;
                        --x;
                    }
                    while (x >= 0) {
                        p01 = in_ptr[idx++];
                        p11 = in_ptr[idx2++];
                        fx = p11 - p00;
                        fy = p10 - p01;
                        out_ptr[idx - 2] = (fx < 0 ? -fx : fx) + (fy < 0 ? -fy : fy) >> 1;
                        p00 = p01;
                        p10 = p11;
                        p01 = in_ptr[idx++];
                        p11 = in_ptr[idx2++];
                        fx = p11 - p00;
                        fy = p10 - p01;
                        out_ptr[idx - 2] = (fx < 0 ? -fx : fx) + (fy < 0 ? -fy : fy) >> 1;
                        p00 = p01;
                        p10 = p11;
                        p01 = in_ptr[idx++];
                        p11 = in_ptr[idx2++];
                        fx = p11 - p00;
                        fy = p10 - p01;
                        out_ptr[idx - 2] = (fx < 0 ? -fx : fx) + (fy < 0 ? -fy : fy) >> 1;
                        p00 = p01;
                        p10 = p11;
                        p01 = in_ptr[idx++];
                        p11 = in_ptr[idx2++];
                        fx = p11 - p00;
                        fy = p10 - p01;
                        out_ptr[idx - 2] = (fx < 0 ? -fx : fx) + (fy < 0 ? -fy : fy) >> 1;
                        p00 = p01;
                        p10 = p11;
                        x -= 4;
                    }
                    out_ptr[idx - 1] = 0;
                    --y;
                }
                int x = width - 1;
                while (x >= 0) {
                    out_ptr[idx++] = 0;
                    --x;
                }
                return;
            }
        }
        throw new NyARException();
    }
}

