/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.squaredetect;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.labeling.NyARLabelOverlapChecker;
import jp.nyatla.nyartoolkit.core.labeling.artoolkit.NyARLabelingImage;
import jp.nyatla.nyartoolkit.core.labeling.artoolkit.NyARLabelingLabel;
import jp.nyatla.nyartoolkit.core.labeling.artoolkit.NyARLabelingLabelStack;
import jp.nyatla.nyartoolkit.core.labeling.artoolkit.NyARLabeling_ARToolKit;
import jp.nyatla.nyartoolkit.core.raster.NyARBinRaster;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARContourPickup_ARToolKit;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARCoord2SquareVertexIndexes;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquareContourDetector;
import jp.nyatla.nyartoolkit.core.types.NyARIntCoordinates;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public abstract class NyARSquareContourDetector_ARToolKit
extends NyARSquareContourDetector {
    private static final int AR_AREA_MAX = 100000;
    private static final int AR_AREA_MIN = 70;
    private final int _width;
    private final int _height;
    private final NyARLabeling_ARToolKit _labeling;
    private final NyARLabelingImage _limage;
    private final NyARLabelOverlapChecker<NyARLabelingLabel> _overlap_checker = new NyARLabelOverlapChecker<NyARLabelingLabel>(32, NyARLabelingLabel.class);
    private final NyARContourPickup_ARToolKit _cpickup = new NyARContourPickup_ARToolKit();
    private final NyARCoord2SquareVertexIndexes _coord2vertex = new NyARCoord2SquareVertexIndexes();
    private final NyARIntCoordinates _coord;
    private final int[] __detectMarker_mkvertex = new int[4];

    public NyARSquareContourDetector_ARToolKit(NyARIntSize i_size) throws NyARException {
        this._width = i_size.w;
        this._height = i_size.h;
        this._labeling = new NyARLabeling_ARToolKit();
        this._limage = new NyARLabelingImage(this._width, this._height);
        int number_of_coord = (this._width + this._height) * 2;
        this._coord = new NyARIntCoordinates(number_of_coord);
    }

    public final void detectMarker(NyARBinRaster i_raster) throws NyARException {
        NyARLabelingImage limage = this._limage;
        int label_num = this._labeling.labeling(i_raster, this._limage);
        if (label_num < 1) {
            return;
        }
        NyARLabelingLabelStack stack = limage.getLabelStack();
        stack.sortByArea();
        NyARLabelingLabel[] labels = (NyARLabelingLabel[])stack.getArray();
        int i = 0;
        while (i < label_num) {
            if (labels[i].area <= 100000) break;
            ++i;
        }
        int xsize = this._width;
        int ysize = this._height;
        NyARIntCoordinates coord = this._coord;
        int[] mkvertex = this.__detectMarker_mkvertex;
        NyARLabelOverlapChecker<NyARLabelingLabel> overlap = this._overlap_checker;
        overlap.setMaxLabels(label_num);
        while (i < label_num) {
            NyARLabelingLabel label_pt = labels[i];
            int label_area = label_pt.area;
            if (label_area < 70) break;
            if (label_pt.clip_l != 1 && label_pt.clip_r != xsize - 2 && label_pt.clip_t != 1 && label_pt.clip_b != ysize - 2 && overlap.check(label_pt) && this._cpickup.getContour(limage, limage.getTopClipTangentX(label_pt), label_pt.clip_t, coord) && this._coord2vertex.getVertexIndexes(coord, label_area, mkvertex)) {
                this.onSquareDetect(coord, mkvertex);
                overlap.push(label_pt);
            }
            ++i;
        }
    }
}

