/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.markersystem;

import java.io.FileInputStream;
import java.io.InputStream;
import jp.nyatla.nyartoolkit.core.NyARCode;
import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.analyzer.histogram.INyARHistogramAnalyzer_Threshold;
import jp.nyatla.nyartoolkit.core.param.NyARFrustum;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.NyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterdriver.INyARPerspectiveCopy;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint3d;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix44;
import jp.nyatla.nyartoolkit.markersystem.INyARMarkerSystemConfig;
import jp.nyatla.nyartoolkit.markersystem.NyARSensor;
import jp.nyatla.nyartoolkit.markersystem.RleDetector;
import jp.nyatla.nyartoolkit.markersystem.utils.MarkerInfoARMarker;
import jp.nyatla.nyartoolkit.markersystem.utils.MarkerInfoNyId;

public class NyARMarkerSystem {
    public static int THLESHOLD_AUTO = -1;
    public static double FRUSTUM_DEFAULT_FAR_CLIP = 10000.0;
    public static double FRUSTUM_DEFAULT_NEAR_CLIP = 10.0;
    public static final int LOST_DELAY_DEFAULT = 5;
    private static int MASK_IDTYPE = -4096;
    private static int MASK_IDNUM = 4095;
    private static int IDTYPE_ARTK = 0;
    private static int IDTYPE_NYID = 4096;
    private RleDetector _rledetect;
    protected NyARParam _ref_param;
    protected NyARFrustum _frustum;
    private int _last_gs_th;
    private int _bin_threshold = THLESHOLD_AUTO;
    private NyARDoublePoint3d _wk_3dpos = new NyARDoublePoint3d();
    private NyARDoublePoint3d[] __pos3d = NyARDoublePoint3d.createArray(4);
    private NyARDoublePoint2d[] __pos2d = NyARDoublePoint2d.createArray(4);
    private long _time_stamp = -1L;
    private INyARHistogramAnalyzer_Threshold _hist_th;

    public NyARMarkerSystem(INyARMarkerSystemConfig i_config) throws NyARException {
        this._ref_param = i_config.getNyARParam();
        this._frustum = new NyARFrustum();
        this.initInstance(i_config);
        this.setProjectionMatrixClipping(FRUSTUM_DEFAULT_NEAR_CLIP, FRUSTUM_DEFAULT_FAR_CLIP);
    }

    protected void initInstance(INyARMarkerSystemConfig i_ref_config) throws NyARException {
        this._rledetect = new RleDetector(i_ref_config);
        this._hist_th = i_ref_config.createAutoThresholdArgorism();
    }

    public NyARFrustum getFrustum() {
        return this._frustum;
    }

    public NyARParam getARParam() {
        return this._ref_param;
    }

    public void setProjectionMatrixClipping(double i_near, double i_far) {
        NyARIntSize s = this._ref_param.getScreenSize();
        this._frustum.setValue(this._ref_param.getPerspectiveProjectionMatrix(), s.w, s.h, i_near, i_far);
    }

    public int addNyIdMarker(long i_id, double i_marker_size) throws NyARException {
        MarkerInfoNyId target = new MarkerInfoNyId(i_id, i_id, i_marker_size);
        if (!this._rledetect._idmk_list.add(target)) {
            throw new NyARException();
        }
        if (!this._rledetect._tracking_list.add(target)) {
            throw new NyARException();
        }
        return this._rledetect._idmk_list.size() - 1 | IDTYPE_NYID;
    }

    public int addNyIdMarker(long i_id_s, long i_id_e, double i_marker_size) throws NyARException {
        MarkerInfoNyId target = new MarkerInfoNyId(i_id_s, i_id_e, i_marker_size);
        if (!this._rledetect._idmk_list.add(target)) {
            throw new NyARException();
        }
        this._rledetect._tracking_list.add(target);
        return this._rledetect._idmk_list.size() - 1 | IDTYPE_NYID;
    }

    public int addARMarker(NyARCode i_code, int i_patt_edge_percentage, double i_marker_size) throws NyARException {
        MarkerInfoARMarker target = new MarkerInfoARMarker(i_code, i_patt_edge_percentage, i_marker_size);
        if (!this._rledetect._armk_list.add(target)) {
            throw new NyARException();
        }
        this._rledetect._tracking_list.add(target);
        return this._rledetect._armk_list.size() - 1 | IDTYPE_ARTK;
    }

    public int addARMarker(InputStream i_stream, int i_patt_resolution, int i_patt_edge_percentage, double i_marker_size) throws NyARException {
        NyARCode c = new NyARCode(i_patt_resolution, i_patt_resolution);
        c.loadARPatt(i_stream);
        return this.addARMarker(c, i_patt_edge_percentage, i_marker_size);
    }

    public int addARMarker(String i_file_name, int i_patt_resolution, int i_patt_edge_percentage, double i_marker_size) throws NyARException {
        NyARCode c = new NyARCode(i_patt_resolution, i_patt_resolution);
        try {
            c.loadARPatt(new FileInputStream(i_file_name));
        }
        catch (Exception e) {
            throw new NyARException(e);
        }
        return this.addARMarker(c, i_patt_edge_percentage, i_marker_size);
    }

    public int addARMarker(INyARRgbRaster i_raster, int i_patt_resolution, int i_patt_edge_percentage, double i_marker_size) throws NyARException {
        NyARCode c = new NyARCode(i_patt_resolution, i_patt_resolution);
        NyARIntSize s = i_raster.getSize();
        INyARPerspectiveCopy pc = (INyARPerspectiveCopy)i_raster.createInterface(INyARPerspectiveCopy.class);
        NyARRgbRaster tr = new NyARRgbRaster(i_patt_resolution, i_patt_resolution);
        pc.copyPatt(0.0, 0.0, s.w, 0.0, s.w, s.h, 0.0, s.h, i_patt_edge_percentage, i_patt_edge_percentage, 4, tr);
        c.setRaster(tr);
        this.addARMarker(c, i_patt_edge_percentage, i_marker_size);
        return 0;
    }

    public boolean isExistMarker(int i_id) {
        return this.getLife(i_id) > 0L;
    }

    public double getConfidence(int i_id) throws NyARException {
        if ((i_id & MASK_IDTYPE) == IDTYPE_ARTK) {
            return ((MarkerInfoARMarker)this._rledetect._armk_list.get((int)(i_id & NyARMarkerSystem.MASK_IDNUM))).cf;
        }
        throw new NyARException();
    }

    public long getNyId(int i_id) throws NyARException {
        if ((i_id & MASK_IDTYPE) == IDTYPE_NYID) {
            return ((MarkerInfoNyId)this._rledetect._idmk_list.get((int)(i_id & NyARMarkerSystem.MASK_IDNUM))).nyid;
        }
        throw new NyARException();
    }

    public int getCurrentThreshold() {
        return this._last_gs_th;
    }

    public long getLife(int i_id) {
        if ((i_id & MASK_IDTYPE) == IDTYPE_ARTK) {
            return ((MarkerInfoARMarker)this._rledetect._armk_list.get((int)(i_id & NyARMarkerSystem.MASK_IDNUM))).life;
        }
        return ((MarkerInfoNyId)this._rledetect._idmk_list.get((int)(i_id & NyARMarkerSystem.MASK_IDNUM))).life;
    }

    public long getLostCount(int i_id) {
        if ((i_id & MASK_IDTYPE) == IDTYPE_ARTK) {
            return ((MarkerInfoARMarker)this._rledetect._armk_list.get((int)(i_id & NyARMarkerSystem.MASK_IDNUM))).lost_count;
        }
        return ((MarkerInfoNyId)this._rledetect._idmk_list.get((int)(i_id & NyARMarkerSystem.MASK_IDNUM))).lost_count;
    }

    public NyARDoublePoint3d getMarkerPlanePos(int i_id, int i_x, int i_y, NyARDoublePoint3d i_out) {
        this._frustum.unProjectOnMatrix(i_x, i_y, this.getMarkerMatrix(i_id), i_out);
        return i_out;
    }

    public NyARDoublePoint2d getScreenPos(int i_id, double i_x, double i_y, double i_z, NyARDoublePoint2d i_out) {
        NyARDoublePoint3d _wk_3dpos = this._wk_3dpos;
        this.getMarkerMatrix(i_id).transform3d(i_x, i_y, i_z, _wk_3dpos);
        this._frustum.project(_wk_3dpos, i_out);
        return i_out;
    }

    public INyARRgbRaster getMarkerPlaneImage(int i_id, NyARSensor i_sensor, int i_x1, int i_y1, int i_x2, int i_y2, int i_x3, int i_y3, int i_x4, int i_y4, INyARRgbRaster i_raster) throws NyARException {
        NyARDoublePoint3d[] pos = this.__pos3d;
        NyARDoublePoint2d[] pos2 = this.__pos2d;
        NyARDoubleMatrix44 tmat = this.getMarkerMatrix(i_id);
        tmat.transform3d(i_x1, i_y1, 0.0, pos[1]);
        tmat.transform3d(i_x2, i_y2, 0.0, pos[0]);
        tmat.transform3d(i_x3, i_y3, 0.0, pos[3]);
        tmat.transform3d(i_x4, i_y4, 0.0, pos[2]);
        int i = 3;
        while (i >= 0) {
            this._frustum.project(pos[i], pos2[i]);
            --i;
        }
        return i_sensor.getPerspectiveImage(pos2[0].x, pos2[0].y, pos2[1].x, pos2[1].y, pos2[2].x, pos2[2].y, pos2[3].x, pos2[3].y, i_raster);
    }

    public INyARRgbRaster getMarkerPlaneImage(int i_id, NyARSensor i_sensor, int i_l, int i_t, int i_w, int i_h, INyARRgbRaster i_raster) throws NyARException {
        return this.getMarkerPlaneImage(i_id, i_sensor, i_l + i_w - 1, i_t + i_h - 1, i_l, i_t + i_h - 1, i_l, i_t, i_l + i_w - 1, i_t, i_raster);
    }

    public NyARDoubleMatrix44 getMarkerMatrix(int i_id) {
        if ((i_id & MASK_IDTYPE) == IDTYPE_ARTK) {
            return ((MarkerInfoARMarker)this._rledetect._armk_list.get((int)(i_id & NyARMarkerSystem.MASK_IDNUM))).tmat;
        }
        return ((MarkerInfoNyId)this._rledetect._idmk_list.get((int)(i_id & NyARMarkerSystem.MASK_IDNUM))).tmat;
    }

    public NyARIntPoint2d[] getMarkerVertex2D(int i_id) {
        if ((i_id & MASK_IDTYPE) == IDTYPE_ARTK) {
            return ((MarkerInfoARMarker)this._rledetect._armk_list.get((int)(i_id & NyARMarkerSystem.MASK_IDNUM))).tl_vertex;
        }
        return ((MarkerInfoNyId)this._rledetect._idmk_list.get((int)(i_id & NyARMarkerSystem.MASK_IDNUM))).tl_vertex;
    }

    public void setBinThreshold(int i_th) {
        this._bin_threshold = i_th;
    }

    public void setConfidenceThreshold(double i_val) {
        this._rledetect._armk_list.setConficenceTh(i_val);
    }

    public void setLostDelay(int i_delay) {
        this._rledetect.lost_th = i_delay;
    }

    public void update(NyARSensor i_sensor) throws NyARException {
        long time_stamp = i_sensor.getTimeStamp();
        if (this._time_stamp == time_stamp) {
            return;
        }
        int th = this._bin_threshold == THLESHOLD_AUTO ? this._hist_th.getThreshold(i_sensor.getGsHistogram()) : this._bin_threshold;
        this._rledetect.detectMarker(i_sensor, time_stamp, th);
        this._time_stamp = time_stamp;
        this._last_gs_th = th;
    }
}

