/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.rpf.mklib;

import java.io.InputStream;
import jp.nyatla.nyartoolkit.core.NyARCode;
import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPattDeviationColorData;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPattResult;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPatt_Color_WITHOUT_PCA;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.NyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterdriver.INyARPerspectiveCopy;
import jp.nyatla.nyartoolkit.core.types.stack.NyARObjectStack;
import jp.nyatla.nyartoolkit.rpf.reality.nyartk.NyARRealityTarget;
import jp.nyatla.nyartoolkit.rpf.realitysource.nyartk.NyARRealitySource;

public class ARTKMarkerTable {
    private int _resolution_width;
    private int _resolution_height;
    private int _edge_x;
    private int _edge_y;
    private int _sample_per_pix;
    private NyARRgbRaster _tmp_raster;
    private NyARMatchPatt_Color_WITHOUT_PCA _match_patt;
    private NyARMatchPattDeviationColorData _deviation_data;
    private MarkerTable _table;
    private NyARMatchPattResult __tmp_patt_result = new NyARMatchPattResult();

    public ARTKMarkerTable(int i_max, int i_resolution_x, int i_resolution_y, int i_edge_x, int i_edge_y, int i_sample_per_pix) throws NyARException {
        this._resolution_width = i_resolution_x;
        this._resolution_height = i_resolution_y;
        this._edge_x = i_edge_x;
        this._edge_y = i_edge_y;
        this._sample_per_pix = i_sample_per_pix;
        this._tmp_raster = new NyARRgbRaster(i_resolution_x, i_resolution_y, 262402);
        this._table = new MarkerTable(i_max);
        this._deviation_data = new NyARMatchPattDeviationColorData(i_resolution_x, i_resolution_y);
        this._match_patt = new NyARMatchPatt_Color_WITHOUT_PCA(i_resolution_x, i_resolution_y);
    }

    public boolean addMarker(NyARCode i_code, int i_id, String i_name, double i_width, double i_height) {
        assert (i_code.getHeight() == this._resolution_height && i_code.getHeight() == this._resolution_width);
        MarkerTable.SerialTableRow d = (MarkerTable.SerialTableRow)this._table.prePush();
        if (d == null) {
            return false;
        }
        d.setValue(i_code, i_id, i_name, i_width, i_height);
        return true;
    }

    public boolean addMarker(NyARRgbRaster i_raster, int i_id, String i_name, double i_width, double i_height) throws NyARException {
        MarkerTable.SerialTableRow d = (MarkerTable.SerialTableRow)this._table.prePush();
        if (d == null) {
            return false;
        }
        NyARCode c = new NyARCode(this._resolution_width, this._resolution_height);
        c.setRaster(i_raster);
        d.setValue(c, i_id, i_name, i_width, i_height);
        return true;
    }

    public boolean addMarkerFromARPatt(InputStream i_stream, int i_id, String i_name, double i_width, double i_height) throws NyARException {
        MarkerTable.SerialTableRow d = (MarkerTable.SerialTableRow)this._table.prePush();
        if (d == null) {
            return false;
        }
        NyARCode c = new NyARCode(this._resolution_width, this._resolution_height);
        c.loadARPatt(i_stream);
        d.setValue(c, i_id, i_name, i_width, i_height);
        return true;
    }

    public boolean getBestMatchTarget(NyARRealityTarget i_target, NyARRealitySource i_rtsorce, GetBestMatchTargetResult o_result) throws NyARException {
        NyARMatchPattResult tmp_patt_result = this.__tmp_patt_result;
        INyARPerspectiveCopy r = i_rtsorce.refPerspectiveRasterReader();
        r.copyPatt(i_target.refTargetVertex(), this._edge_x, this._edge_y, this._sample_per_pix, (INyARRgbRaster)this._tmp_raster);
        this._deviation_data.setRaster(this._tmp_raster);
        int ret = -1;
        int dir = -1;
        double cf = Double.MIN_VALUE;
        int i = this._table.getLength() - 1;
        while (i >= 0) {
            this._match_patt.setARCode(((MarkerTable.SerialTableRow)this._table.getItem((int)i)).code);
            this._match_patt.evaluate(this._deviation_data, tmp_patt_result);
            if (cf < tmp_patt_result.confidence) {
                ret = i;
                cf = tmp_patt_result.confidence;
                dir = tmp_patt_result.direction;
            }
            --i;
        }
        if (ret < 0) {
            return false;
        }
        MarkerTable.SerialTableRow row = (MarkerTable.SerialTableRow)this._table.getItem(ret);
        o_result.artk_direction = dir;
        o_result.confidence = cf;
        o_result.idtag = row.idtag;
        o_result.marker_height = row.marker_height;
        o_result.marker_width = row.marker_width;
        o_result.name = row.name;
        return true;
    }

    public static class GetBestMatchTargetResult {
        public int idtag;
        public String name;
        public double marker_width;
        public double marker_height;
        public int artk_direction;
        public double confidence;
    }

    private class MarkerTable
    extends NyARObjectStack<SerialTableRow> {
        public MarkerTable(int i_length) throws NyARException {
            super.initInstance(i_length, SerialTableRow.class);
        }

        @Override
        protected SerialTableRow createElement() {
            return new SerialTableRow();
        }

        public class SerialTableRow {
            public int idtag;
            public String name;
            public NyARCode code;
            public double marker_width;
            public double marker_height;

            public final void setValue(NyARCode i_code, int i_idtag, String i_name, double i_width, double i_height) {
                this.code = i_code;
                this.marker_height = i_height;
                this.marker_width = i_width;
                this.name = i_name;
                this.idtag = i_idtag;
            }
        }
    }
}

