/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.rpf.tracker.nyartk;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.rpf.sampler.lrlabel.LowResolutionLabelingSamplerOut;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.DistMap;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.INyARVectorReader;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.NyARRectTargetList;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.NyARTarget;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.NyARTargetList;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.NyARTargetPool;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.NyARTrackerSource;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.SampleStack;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.status.NyARContourTargetStatus;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.status.NyARContourTargetStatusPool;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.status.NyARNewTargetStatus;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.status.NyARNewTargetStatusPool;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.status.NyARRectTargetStatus;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.status.NyARRectTargetStatusPool;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.status.NyARTargetStatus;

public class NyARTracker {
    private DistMap _map;
    protected int[] _index;
    private NyARNewTargetStatusPool newst_pool;
    private NyARContourTargetStatusPool contourst_pool;
    private NyARRectTargetStatusPool rect_pool;
    private NyARTargetPool target_pool;
    public NyARTargetList _targets;
    private final int MAX_NUMBER_OF_NEW;
    private final int MAX_NUMBER_OF_CONTURE;
    private final int MAX_NUMBER_OF_RECT;
    private final int MAX_NUMBER_OF_TARGET;
    private SampleStack _newsource;
    private SampleStack _igsource;
    private SampleStack _coordsource;
    private SampleStack _rectsource;
    public NyARTargetList[] _temp_targets;
    private int _number_of_new;
    private int _number_of_ignore;
    private int _number_of_contoure;
    private int _number_of_rect;
    private static final int LIFE_OF_NEW = 10;
    private static final int LIFE_OF_IGNORE_FROM_NEW = 10;
    private static final int LIFE_OF_IGNORE_FROM_CONTOUR = 50;
    private static final int LIFE_OF_IGNORE_FROM_RECT = 20;
    private static final int LIFE_OF_RECT_FROM_CONTOUR = Integer.MAX_VALUE;
    private static final int LIFE_OF_CONTURE_FROM_NEW = 2;

    public final int getNumberOfNew() {
        return this._number_of_new;
    }

    public final int getNumberOfIgnore() {
        return this._number_of_ignore;
    }

    public final int getNumberOfContur() {
        return this._number_of_contoure;
    }

    public final int getNumberOfRect() {
        return this._number_of_rect;
    }

    public final NyARTargetList refTrackTarget() {
        return this._targets;
    }

    public NyARTracker(int i_max_new, int i_max_cont, int i_max_rect) throws NyARException {
        this.MAX_NUMBER_OF_NEW = i_max_new;
        this.MAX_NUMBER_OF_CONTURE = i_max_cont;
        this.MAX_NUMBER_OF_RECT = i_max_rect;
        this.MAX_NUMBER_OF_TARGET = (i_max_new + i_max_cont + i_max_rect) * 5;
        this._temp_targets = new NyARTargetList[4];
        this._temp_targets[1] = new NyARTargetList(i_max_new);
        this._temp_targets[0] = new NyARTargetList(this.MAX_NUMBER_OF_TARGET);
        this._temp_targets[3] = new NyARTargetList(i_max_cont);
        this._temp_targets[2] = new NyARRectTargetList(i_max_rect);
        this._newsource = new SampleStack(i_max_new);
        this._igsource = new SampleStack(this.MAX_NUMBER_OF_TARGET);
        this._coordsource = new SampleStack(i_max_cont);
        this._rectsource = new SampleStack(i_max_rect);
        this.newst_pool = new NyARNewTargetStatusPool(i_max_new * 2);
        this.contourst_pool = new NyARContourTargetStatusPool(i_max_rect + i_max_cont * 2);
        this.rect_pool = new NyARRectTargetStatusPool(i_max_rect * 2);
        this.target_pool = new NyARTargetPool(this.MAX_NUMBER_OF_TARGET);
        this._targets = new NyARTargetList(this.MAX_NUMBER_OF_TARGET);
        this._map = new DistMap(this.MAX_NUMBER_OF_TARGET, this.MAX_NUMBER_OF_TARGET);
        this._index = new int[this.MAX_NUMBER_OF_TARGET];
        this._number_of_rect = 0;
        this._number_of_contoure = 0;
        this._number_of_ignore = 0;
        this._number_of_new = 0;
    }

    public void progress(NyARTrackerSource i_s) throws NyARException {
        LowResolutionLabelingSamplerOut sample_out = i_s.makeSampleOut();
        NyARTargetList[] targets = this._temp_targets;
        NyARTargetList newtr = targets[1];
        NyARTargetList igtr = targets[0];
        NyARTargetList cotr = targets[3];
        NyARTargetList retw = targets[2];
        INyARVectorReader vecreader = i_s.getBaseVectorReader();
        NyARTarget[] target_array = (NyARTarget[])this._targets.getArray();
        newtr.clear();
        igtr.clear();
        cotr.clear();
        retw.clear();
        int i = this._targets.getLength() - 1;
        while (i >= 0) {
            targets[target_array[i]._st_type].pushAssert(target_array[i]);
            --i;
        }
        int[] index = this._index;
        this.sampleMapper(sample_out, newtr, igtr, cotr, retw, this._newsource, this._igsource, this._coordsource, this._rectsource);
        this._map.makePairIndexes(this._igsource, igtr, index);
        NyARTracker.updateIgnoreStatus(igtr, (LowResolutionLabelingSamplerOut.Item[])this._igsource.getArray(), index);
        this._map.makePairIndexes(this._newsource, newtr, index);
        NyARTracker.updateNewStatus(newtr, this.newst_pool, (LowResolutionLabelingSamplerOut.Item[])this._newsource.getArray(), index);
        this._map.makePairIndexes(this._rectsource, retw, index);
        NyARTracker.updateRectStatus(retw, vecreader, this.rect_pool, (LowResolutionLabelingSamplerOut.Item[])this._rectsource.getArray(), index);
        this._map.makePairIndexes(this._coordsource, cotr, index);
        NyARTracker.updateContureStatus(cotr, vecreader, this.contourst_pool, (LowResolutionLabelingSamplerOut.Item[])this._coordsource.getArray(), index);
        int i2 = this._targets.getLength() - 1;
        while (i2 >= 0) {
            switch (target_array[i2]._st_type) {
                case 0: {
                    this.upgradeIgnoreTarget(i2);
                    break;
                }
                case 1: {
                    this.upgradeNewTarget(target_array[i2], vecreader);
                    break;
                }
                case 2: {
                    this.upgradeRectTarget(target_array[i2]);
                    break;
                }
                case 3: {
                    this.upgradeContourTarget(target_array[i2]);
                }
            }
            --i2;
        }
    }

    private final void upgradeNewTarget(NyARTarget i_new_target, INyARVectorReader i_vecreader) throws NyARException {
        assert (i_new_target._st_type == 1);
        if (i_new_target._status_life <= 0) {
            this.changeStatusToIgnore(i_new_target, 10);
            return;
        }
        NyARNewTargetStatus st = (NyARNewTargetStatus)i_new_target._ref_status;
        if (st.current_sampleout == null) {
            return;
        }
        NyARContourTargetStatus c = (NyARContourTargetStatus)this.contourst_pool.newObject();
        if (c == null) {
            System.out.println("upgradeNewTarget:status pool full");
            return;
        }
        if (!c.setValue(i_vecreader, st.current_sampleout)) {
            this.changeStatusToIgnore(i_new_target, 10);
            c.releaseObject();
            return;
        }
        if (this.changeStatusToCntoure(i_new_target, c) == null) {
            c.releaseObject();
            return;
        }
    }

    private final void upgradeIgnoreTarget(int i_ig_index) throws NyARException {
        assert (((NyARTarget)this._targets.getItem((int)i_ig_index))._st_type == 0);
        if (((NyARTarget)this._targets.getItem((int)i_ig_index))._status_life <= 0) {
            this.deleatTarget(i_ig_index);
        }
    }

    private final void upgradeContourTarget(NyARTarget i_contoure_target) throws NyARException {
        assert (i_contoure_target._st_type == 3);
        if (i_contoure_target._status_life <= 0) {
            this.changeStatusToIgnore(i_contoure_target, 50);
            return;
        }
        if (i_contoure_target._delay_tick > 20) {
            this.changeStatusToIgnore(i_contoure_target, 50);
            return;
        }
        NyARContourTargetStatus st = (NyARContourTargetStatus)i_contoure_target._ref_status;
        NyARRectTargetStatus c = (NyARRectTargetStatus)this.rect_pool.newObject();
        if (c == null) {
            return;
        }
        if (!c.setValueWithInitialCheck(st, i_contoure_target._sample_area)) {
            c.releaseObject();
            return;
        }
        if (this.changeStatusToRect(i_contoure_target, c) == null) {
            c.releaseObject();
            return;
        }
    }

    private final void upgradeRectTarget(NyARTarget i_rect_target) throws NyARException {
        assert (i_rect_target._st_type == 2);
        if (i_rect_target._delay_tick > 20) {
            this.changeStatusToIgnore(i_rect_target, 20);
        }
    }

    private static final void updateIgnoreStatus(NyARTargetList i_igliet, LowResolutionLabelingSamplerOut.Item[] source, int[] index) {
        NyARTarget[] i_ignore_target = (NyARTarget[])i_igliet.getArray();
        int i = i_igliet.getLength() - 1;
        while (i >= 0) {
            NyARTarget d_ptr = i_ignore_target[i];
            int sample_index = index[i];
            --d_ptr._status_life;
            if (sample_index < 0) {
                ++d_ptr._delay_tick;
            } else {
                d_ptr.setSampleArea(source[sample_index]);
                d_ptr._delay_tick = 0;
            }
            --i;
        }
    }

    private static final void updateNewStatus(NyARTargetList i_list, NyARNewTargetStatusPool i_pool, LowResolutionLabelingSamplerOut.Item[] source, int[] index) throws NyARException {
        NyARTarget[] i_nes = (NyARTarget[])i_list.getArray();
        int i = i_list.getLength() - 1;
        while (i >= 0) {
            NyARTarget d_ptr = i_nes[i];
            int sample_index = index[i];
            --d_ptr._status_life;
            if (sample_index < 0) {
                ((NyARNewTargetStatus)d_ptr._ref_status).setValue(null);
                ++d_ptr._delay_tick;
            } else {
                LowResolutionLabelingSamplerOut.Item s = source[sample_index];
                NyARNewTargetStatus st = (NyARNewTargetStatus)i_pool.newObject();
                if (st == null) {
                    ++d_ptr._delay_tick;
                } else {
                    st.setValue(s);
                    d_ptr.setSampleArea(s);
                    d_ptr._delay_tick = 0;
                    d_ptr._ref_status.releaseObject();
                    d_ptr._ref_status = st;
                }
            }
            --i;
        }
    }

    private static void updateContureStatus(NyARTargetList i_list, INyARVectorReader i_vecreader, NyARContourTargetStatusPool i_stpool, LowResolutionLabelingSamplerOut.Item[] source, int[] index) throws NyARException {
        NyARTarget[] crd = (NyARTarget[])i_list.getArray();
        int i = i_list.getLength() - 1;
        while (i >= 0) {
            NyARTarget d_ptr = crd[i];
            int sample_index = index[i];
            --d_ptr._status_life;
            if (sample_index < 0) {
                ++d_ptr._delay_tick;
            } else {
                LowResolutionLabelingSamplerOut.Item s = source[sample_index];
                NyARContourTargetStatus st = (NyARContourTargetStatus)i_stpool.newObject();
                if (st == null) {
                    ++d_ptr._delay_tick;
                } else if (!st.setValue(i_vecreader, s)) {
                    st.releaseObject();
                    ++d_ptr._delay_tick;
                } else {
                    d_ptr.setSampleArea(s);
                    d_ptr._delay_tick = 0;
                    d_ptr._ref_status.releaseObject();
                    d_ptr._ref_status = st;
                }
            }
            --i;
        }
    }

    private static void updateRectStatus(NyARTargetList i_list, INyARVectorReader i_vecreader, NyARRectTargetStatusPool i_stpool, LowResolutionLabelingSamplerOut.Item[] source, int[] index) throws NyARException {
        NyARTarget[] rct = (NyARTarget[])i_list.getArray();
        int i = i_list.getLength() - 1;
        while (i >= 0) {
            NyARTarget d_ptr = rct[i];
            --d_ptr._status_life;
            NyARRectTargetStatus st = (NyARRectTargetStatus)i_stpool.newObject();
            if (st == null) {
                ++d_ptr._delay_tick;
            } else {
                LowResolutionLabelingSamplerOut.Item s;
                int sample_index = index[i];
                LowResolutionLabelingSamplerOut.Item item = s = sample_index < 0 ? null : source[sample_index];
                if (!st.setValueByAutoSelect(i_vecreader, s, (NyARRectTargetStatus)d_ptr._ref_status)) {
                    st.releaseObject();
                    ++d_ptr._delay_tick;
                } else {
                    if (s != null) {
                        d_ptr.setSampleArea(s);
                    }
                    d_ptr._ref_status.releaseObject();
                    d_ptr._ref_status = st;
                    d_ptr._delay_tick = 0;
                }
            }
            --i;
        }
    }

    private final void sampleMapper(LowResolutionLabelingSamplerOut i_source, NyARTargetList i_new, NyARTargetList i_ig, NyARTargetList i_cood, NyARTargetList i_rect, SampleStack i_newsrc, SampleStack i_igsrc, SampleStack i_coodsrc, SampleStack i_rectsrc) throws NyARException {
        i_newsrc.clear();
        i_coodsrc.clear();
        i_igsrc.clear();
        i_rectsrc.clear();
        LowResolutionLabelingSamplerOut.Item[] sample_items = i_source.getArray();
        int i = i_source.getLength() - 1;
        while (i >= 0) {
            LowResolutionLabelingSamplerOut.Item sample_item = sample_items[i];
            int id = i_rect.getMatchTargetIndex(sample_item);
            if (id >= 0) {
                i_rectsrc.push(sample_item);
            } else {
                id = i_cood.getMatchTargetIndex(sample_item);
                if (id >= 0) {
                    i_coodsrc.push(sample_item);
                } else {
                    id = i_new.getMatchTargetIndex(sample_item);
                    if (id >= 0) {
                        i_newsrc.push(sample_item);
                    } else {
                        id = i_ig.getMatchTargetIndex(sample_item);
                        if (id >= 0) {
                            i_igsrc.push(sample_item);
                        } else {
                            NyARTarget t = this.addNewTarget(sample_item);
                            if (t != null) {
                                i_newsrc.push(sample_item);
                            }
                        }
                    }
                }
            }
            --i;
        }
    }

    private final NyARTarget addNewTarget(LowResolutionLabelingSamplerOut.Item i_sample) throws NyARException {
        if (this._number_of_new >= this.MAX_NUMBER_OF_NEW) {
            return null;
        }
        NyARTarget t = this.target_pool.newNewTarget();
        if (t == null) {
            return null;
        }
        t._status_life = 10;
        t._st_type = 1;
        t._delay_tick = 0;
        t.setSampleArea(i_sample);
        t._ref_status = (NyARTargetStatus)this.newst_pool.newObject();
        if (t._ref_status == null) {
            t.releaseObject();
            return null;
        }
        ((NyARNewTargetStatus)t._ref_status).setValue(i_sample);
        this._targets.pushAssert(t);
        ++this._number_of_new;
        return t;
    }

    private final void deleatTarget(int i_index) throws NyARException {
        assert (((NyARTarget)this._targets.getItem((int)i_index))._st_type == 0);
        NyARTarget tr = (NyARTarget)this._targets.getItem(i_index);
        this._targets.removeIgnoreOrder(i_index);
        tr.releaseObject();
        --this._number_of_ignore;
    }

    public final void changeStatusToIgnore(NyARTarget i_target, int i_life) throws NyARException {
        assert (i_target._st_type == 1 || i_target._st_type == 3 || i_target._st_type == 2);
        switch (i_target._st_type) {
            case 1: {
                --this._number_of_new;
                break;
            }
            case 2: {
                --this._number_of_rect;
                break;
            }
            case 3: {
                --this._number_of_contoure;
                break;
            }
            default: {
                return;
            }
        }
        i_target._st_type = 0;
        i_target._ref_status.releaseObject();
        i_target._status_life = i_life;
        i_target._ref_status = null;
        ++this._number_of_ignore;
    }

    private final NyARTarget changeStatusToCntoure(NyARTarget i_target, NyARContourTargetStatus i_c) {
        assert (i_c != null);
        assert (i_target._st_type == 1);
        if (this._number_of_contoure >= this.MAX_NUMBER_OF_CONTURE) {
            return null;
        }
        i_target._st_type = 3;
        i_target._ref_status.releaseObject();
        i_target._status_life = 2;
        i_target._ref_status = i_c;
        --this._number_of_new;
        ++this._number_of_contoure;
        return i_target;
    }

    private final NyARTarget changeStatusToRect(NyARTarget i_target, NyARRectTargetStatus i_c) {
        assert (i_target._st_type == 3);
        if (this._number_of_rect >= this.MAX_NUMBER_OF_RECT) {
            return null;
        }
        i_target._st_type = 2;
        i_target._ref_status.releaseObject();
        i_target._status_life = Integer.MAX_VALUE;
        i_target._ref_status = i_c;
        --this._number_of_contoure;
        ++this._number_of_rect;
        return i_target;
    }
}

