/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.raster.rgb;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.pixeldriver.INyARRgbPixelDriver;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public abstract class NyARRgbRaster_BasicClass
implements INyARRgbRaster {
    protected final NyARIntSize _size;
    protected int _buffer_type;

    protected NyARRgbRaster_BasicClass(int i_width, int i_height, int i_buffer_type) {
        this._size = new NyARIntSize(i_width, i_height);
        this._buffer_type = i_buffer_type;
    }

    @Override
    public final int getWidth() {
        return this._size.w;
    }

    @Override
    public final int getHeight() {
        return this._size.h;
    }

    @Override
    public final NyARIntSize getSize() {
        return this._size;
    }

    @Override
    public final int getBufferType() {
        return this._buffer_type;
    }

    @Override
    public final boolean isEqualBufferType(int i_type_value) {
        return this._buffer_type == i_type_value;
    }

    public static void copy(INyARRgbRaster i_input, INyARRgbRaster o_output) throws NyARException {
        assert (i_input.getSize().isEqualSize(o_output.getSize()));
        int width = i_input.getWidth();
        int height = i_input.getHeight();
        int[] rgb = new int[3];
        INyARRgbPixelDriver inr = i_input.getRgbPixelDriver();
        INyARRgbPixelDriver outr = o_output.getRgbPixelDriver();
        int i = height - 1;
        while (i >= 0) {
            int i2 = width - 1;
            while (i2 >= 0) {
                inr.getPixel(i2, i, rgb);
                outr.setPixel(i2, i, rgb);
                --i2;
            }
            --i;
        }
    }

    @Override
    public abstract boolean hasBuffer();

    @Override
    public abstract INyARRgbPixelDriver getRgbPixelDriver() throws NyARException;

    @Override
    public abstract void wrapBuffer(Object var1) throws NyARException;

    @Override
    public abstract Object createInterface(Class<?> var1) throws NyARException;

    @Override
    public abstract Object getBuffer();
}

