/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyar4psg;

import jp.nyatla.nyar4psg.NyAR4PsgConfig;
import jp.nyatla.nyar4psg.SingleMarkerBaseClass;
import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquare;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix44;
import jp.nyatla.nyartoolkit.nyidmarker.data.INyIdMarkerData;
import jp.nyatla.nyartoolkit.nyidmarker.data.INyIdMarkerDataEncoder;
import jp.nyatla.nyartoolkit.nyidmarker.data.NyIdMarkerDataEncoder_RawBit;
import jp.nyatla.nyartoolkit.nyidmarker.data.NyIdMarkerData_RawBit;
import jp.nyatla.nyartoolkit.processor.SingleNyIdMarkerProcesser;
import processing.core.PApplet;
import processing.core.PImage;

public class SingleNyIdMarker
extends SingleMarkerBaseClass {
    public static final int ST_NOMARKER = 0;
    public static final int ST_NEWMARKER = 1;
    public static final int ST_UPDATEMARKER = 2;
    public static final int ST_REMOVEMARKER = 3;
    public int markerid;
    private MarkerProcessor _marker_proc;
    private boolean _registerd_marker = false;

    public int getNyId() {
        return this.markerid;
    }

    public SingleNyIdMarker(PApplet parent, int i_width, int i_height, String i_cparam, NyAR4PsgConfig i_config) {
        try {
            this.initInstance(parent, i_cparam, i_width, i_height, i_config);
        }
        catch (NyARException e) {
            this._ref_papplet.die("Error on SingleNyIdMarker", (Exception)((Object)e));
        }
    }

    public SingleNyIdMarker(PApplet parent, int i_width, int i_height, String i_cparam) {
        try {
            this.initInstance(parent, i_cparam, i_width, i_height, NyAR4PsgConfig.CONFIG_DEFAULT);
        }
        catch (NyARException e) {
            this._ref_papplet.die("Error on SingleNyIdMarker", (Exception)((Object)e));
        }
    }

    public void setIdMarkerSize(double i_width) {
        if (this._registerd_marker) {
            this._ref_papplet.die("Error already called setIdMarkerSize.", (Exception)((Object)new NyARException()));
        }
        try {
            this._marker_proc = new MarkerProcessor(this, this._ar_param, this._src_raster.getBufferType());
        }
        catch (NyARException e) {
            this._ref_papplet.die("Error on setIdMarkerSize", (Exception)((Object)e));
        }
        this._registerd_marker = true;
    }

    public int detect(PImage i_image) {
        i_image.loadPixels();
        return this.detectWithoutLoadPixels(i_image);
    }

    public int detectWithoutLoadPixels(PImage i_image) {
        if (!this._registerd_marker) {
            this._ref_papplet.die("Must call setIdMarkerSize function in the first.");
        }
        try {
            this._src_raster.wrapBuffer(i_image);
            this._marker_proc.initSequence();
            this._marker_proc.detectMarker((INyARRgbRaster)this._src_raster);
            switch (this._marker_proc.status) {
                case 0: 
                case 3: {
                    this.markerid = -1;
                    break;
                }
                case 1: {
                    this.markerid = this._marker_proc.current_id;
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new NyARException();
                }
            }
        }
        catch (NyARException e) {
            this._ref_papplet.die("Error while marker detecting up NyARToolkit for java", (Exception)((Object)e));
        }
        return this._marker_proc.status;
    }

    private class MarkerProcessor
    extends SingleNyIdMarkerProcesser {
        public int current_id = -1;
        public int status;
        private SingleMarkerBaseClass _parent;
        private boolean _is_prev_onenter;

        public void initSequence() {
            this.status = this.status == 3 ? 0 : this.status;
        }

        public MarkerProcessor(SingleMarkerBaseClass i_parent, NyARParam i_cparam, int i_raster_format) throws NyARException {
            this._parent = i_parent;
            this.initInstance(i_cparam, (INyIdMarkerDataEncoder)new NyIdMarkerDataEncoder_RawBit(), 100.0);
        }

        protected void onLeaveHandler() {
            this.current_id = -1;
            this.status = 3;
        }

        protected void onUpdateHandler(NyARSquare i_square, NyARDoubleMatrix44 result) {
            this._parent.updateTransmat(i_square, result);
            this.status = this._is_prev_onenter ? 1 : 2;
            this._is_prev_onenter = false;
        }

        protected void onEnterHandler(INyIdMarkerData i_code) {
            NyIdMarkerData_RawBit code = (NyIdMarkerData_RawBit)i_code;
            if (code.length > 4) {
                this.current_id = -1;
            } else {
                this.current_id = 0;
                int i = 0;
                while (i < code.length) {
                    this.current_id = this.current_id << 8 | code.packet[i];
                    ++i;
                }
            }
            this.status = 1;
            this._is_prev_onenter = true;
        }
    }
}

