/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.param;

import jp.nyatla.nyartoolkit.core.param.INyARCameraDistortionFactor;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARCameraDistortionFactorV4
implements INyARCameraDistortionFactor {
    public static final int NUM_OF_FACTOR = 9;
    private double _k1;
    private double _k2;
    private double _p1;
    private double _p2;
    private double _fx;
    private double _fy;
    private double _x0;
    private double _y0;
    private double _s;
    private int PD_LOOP2 = 4;

    private double getSizeFactor(double x0, double y0, int xsize, int ysize) {
        double sf1;
        double sf = 100.0;
        double ox = 0.0;
        double oy = y0;
        double olen = x0;
        NyARDoublePoint2d itmp = new NyARDoublePoint2d();
        this.observ2Ideal(ox, oy, itmp);
        double ilen = x0 - itmp.x;
        if (ilen > 0.0 && (sf1 = ilen / olen) < sf) {
            sf = sf1;
        }
        ox = xsize;
        oy = y0;
        olen = (double)xsize - x0;
        this.observ2Ideal(ox, oy, itmp);
        ilen = itmp.x - x0;
        if (ilen > 0.0 && (sf1 = ilen / olen) < sf) {
            sf = sf1;
        }
        ox = x0;
        oy = 0.0;
        olen = y0;
        this.observ2Ideal(ox, oy, itmp);
        ilen = y0 - itmp.y;
        if (ilen > 0.0 && (sf1 = ilen / olen) < sf) {
            sf = sf1;
        }
        ox = x0;
        oy = ysize;
        olen = (double)ysize - y0;
        this.observ2Ideal(ox, oy, itmp);
        ilen = itmp.y - y0;
        if (ilen > 0.0 && (sf1 = ilen / olen) < sf) {
            sf = sf1;
        }
        ox = 0.0;
        oy = 0.0;
        this.observ2Ideal(ox, oy, itmp);
        ilen = x0 - itmp.x;
        olen = x0;
        if (ilen > 0.0 && (sf1 = ilen / olen) < sf) {
            sf = sf1;
        }
        ilen = y0 - itmp.y;
        olen = y0;
        if (ilen > 0.0 && (sf1 = ilen / olen) < sf) {
            sf = sf1;
        }
        ox = xsize;
        oy = 0.0;
        this.observ2Ideal(ox, oy, itmp);
        ilen = itmp.x - x0;
        olen = (double)xsize - x0;
        if (ilen > 0.0 && (sf1 = ilen / olen) < sf) {
            sf = sf1;
        }
        ilen = y0 - itmp.y;
        olen = y0;
        if (ilen > 0.0 && (sf1 = ilen / olen) < sf) {
            sf = sf1;
        }
        ox = 0.0;
        oy = ysize;
        this.observ2Ideal(ox, oy, itmp);
        ilen = x0 - itmp.x;
        olen = x0;
        if (ilen > 0.0 && (sf1 = ilen / olen) < sf) {
            sf = sf1;
        }
        ilen = itmp.y - y0;
        olen = (double)ysize - y0;
        if (ilen > 0.0 && (sf1 = ilen / olen) < sf) {
            sf = sf1;
        }
        ox = xsize;
        oy = ysize;
        this.observ2Ideal(ox, oy, itmp);
        ilen = itmp.x - x0;
        olen = (double)xsize - x0;
        if (ilen > 0.0 && (sf1 = ilen / olen) < sf) {
            sf = sf1;
        }
        ilen = itmp.y - y0;
        olen = (double)ysize - y0;
        if (ilen > 0.0 && (sf1 = ilen / olen) < sf) {
            sf = sf1;
        }
        if (sf == 100.0) {
            sf = 1.0;
        }
        return sf;
    }

    public double getS() {
        return this._s;
    }

    @Override
    public void copyFrom(INyARCameraDistortionFactor i_ref) {
        NyARCameraDistortionFactorV4 src = (NyARCameraDistortionFactorV4)i_ref;
        this._k1 = src._k1;
        this._k2 = src._k2;
        this._p1 = src._p1;
        this._p2 = src._p2;
        this._fx = src._fx;
        this._fy = src._fy;
        this._x0 = src._x0;
        this._y0 = src._y0;
        this._s = src._s;
    }

    public void setValue(NyARIntSize i_size, double[] i_intrinsic_matrix, double[] i_distortion_coeffs) {
        this._k1 = i_distortion_coeffs[0];
        this._k2 = i_distortion_coeffs[1];
        this._p1 = i_distortion_coeffs[2];
        this._p2 = i_distortion_coeffs[3];
        this._fx = i_intrinsic_matrix[0];
        this._fy = i_intrinsic_matrix[4];
        this._x0 = i_intrinsic_matrix[2];
        this._y0 = i_intrinsic_matrix[5];
        this._s = 1.0;
        this._s = this.getSizeFactor(this._x0, this._y0, i_size.w, i_size.h);
    }

    @Override
    public void setValue(double[] i_factor) {
        this._k1 = i_factor[0];
        this._k2 = i_factor[1];
        this._p1 = i_factor[2];
        this._p2 = i_factor[3];
        this._fx = i_factor[4];
        this._fy = i_factor[5];
        this._x0 = i_factor[6];
        this._y0 = i_factor[7];
        this._s = i_factor[8];
    }

    @Override
    public void getValue(double[] o_factor) {
        o_factor[0] = this._k1;
        o_factor[1] = this._k2;
        o_factor[2] = this._p1;
        o_factor[3] = this._p2;
        o_factor[4] = this._fx;
        o_factor[5] = this._fy;
        o_factor[6] = this._x0;
        o_factor[7] = this._y0;
        o_factor[8] = this._s;
    }

    @Override
    public void changeScale(double i_x_scale, double i_y_scale) {
        this._fx *= i_x_scale;
        this._fy *= i_y_scale;
        this._x0 *= i_x_scale;
        this._y0 *= i_y_scale;
    }

    @Override
    public void ideal2Observ(NyARDoublePoint2d i_in, NyARDoublePoint2d o_out) {
        this.ideal2Observ(i_in.x, i_in.y, o_out);
    }

    @Override
    public void ideal2Observ(NyARDoublePoint2d i_in, NyARIntPoint2d o_out) {
        this.ideal2Observ(i_in.x, i_in.y, o_out);
    }

    @Override
    public void ideal2Observ(double i_x, double i_y, NyARDoublePoint2d o_out) {
        double k1 = this._k1;
        double k2 = this._k2;
        double p1 = this._p1;
        double p2 = this._p2;
        double fx = this._fx;
        double fy = this._fy;
        double x0 = this._x0;
        double y0 = this._y0;
        double s = this._s;
        double x = (i_x - x0) * s / fx;
        double y = (i_y - y0) * s / fy;
        double l = x * x + y * y;
        o_out.x = (x * (1.0 + k1 * l + k2 * l * l) + 2.0 * p1 * x * y + p2 * (l + 2.0 * x * x)) * fx + x0;
        o_out.y = (y * (1.0 + k1 * l + k2 * l * l) + p1 * (l + 2.0 * y * y) + 2.0 * p2 * x * y) * fy + y0;
    }

    @Override
    public void ideal2Observ(double i_x, double i_y, NyARIntPoint2d o_out) {
        double k1 = this._k1;
        double k2 = this._k2;
        double p1 = this._p1;
        double p2 = this._p2;
        double fx = this._fx;
        double fy = this._fy;
        double x0 = this._x0;
        double y0 = this._y0;
        double s = this._s;
        double x = (i_x - x0) * s / fx;
        double y = (i_y - y0) * s / fy;
        double l = x * x + y * y;
        o_out.x = (int)((x * (1.0 + k1 * l + k2 * l * l) + 2.0 * p1 * x * y + p2 * (l + 2.0 * x * x)) * fx + x0);
        o_out.y = (int)((y * (1.0 + k1 * l + k2 * l * l) + p1 * (l + 2.0 * y * y) + 2.0 * p2 * x * y) * fy + y0);
    }

    @Override
    public void ideal2ObservBatch(NyARDoublePoint2d[] i_in, NyARDoublePoint2d[] o_out, int i_size) {
        double k1 = this._k1;
        double k2 = this._k2;
        double p1 = this._p1;
        double p2 = this._p2;
        double fx = this._fx;
        double fy = this._fy;
        double x0 = this._x0;
        double y0 = this._y0;
        double s = this._s;
        int i = 0;
        while (i < i_size) {
            double x = (i_in[i].x - x0) * s / fx;
            double y = (i_in[i].y - y0) * s / fy;
            double l = x * x + y * y;
            o_out[i].x = (x * (1.0 + k1 * l + k2 * l * l) + 2.0 * p1 * x * y + p2 * (l + 2.0 * x * x)) * fx + x0;
            o_out[i].y = (y * (1.0 + k1 * l + k2 * l * l) + p1 * (l + 2.0 * y * y) + 2.0 * p2 * x * y) * fy + y0;
            ++i;
        }
    }

    @Override
    public void ideal2ObservBatch(NyARDoublePoint2d[] i_in, NyARIntPoint2d[] o_out, int i_size) {
        double k1 = this._k1;
        double k2 = this._k2;
        double p1 = this._p1;
        double p2 = this._p2;
        double fx = this._fx;
        double fy = this._fy;
        double x0 = this._x0;
        double y0 = this._y0;
        double s = this._s;
        int i = 0;
        while (i < i_size) {
            double x = (i_in[i].x - x0) * s / fx;
            double y = (i_in[i].y - y0) * s / fy;
            double l = x * x + y * y;
            o_out[i].x = (int)((x * (1.0 + k1 * l + k2 * l * l) + 2.0 * p1 * x * y + p2 * (l + 2.0 * x * x)) * fx + x0);
            o_out[i].y = (int)((y * (1.0 + k1 * l + k2 * l * l) + p1 * (l + 2.0 * y * y) + 2.0 * p2 * x * y) * fy + y0);
            ++i;
        }
    }

    @Override
    public void observ2Ideal(double ix, double iy, NyARDoublePoint2d o_point) {
        double k1 = this._k1;
        double k2 = this._k2;
        double p1 = this._p1;
        double p2 = this._p2;
        double fx = this._fx;
        double fy = this._fy;
        double x0 = this._x0;
        double y0 = this._y0;
        double px = (ix - x0) / fx;
        double py = (iy - y0) / fy;
        double x02 = px * px;
        double y02 = py * py;
        int i = 1;
        while (true) {
            if (x02 != 0.0 || y02 != 0.0) {
                px -= ((1.0 + k1 * (x02 + y02) + k2 * (x02 + y02) * (x02 + y02)) * px + 2.0 * p1 * px * py + p2 * (x02 + y02 + 2.0 * x02) - (ix - x0) / fx) / (1.0 + k1 * (3.0 * x02 + y02) + k2 * (5.0 * x02 * x02 + 3.0 * x02 * y02 + y02 * y02) + 2.0 * p1 * py + 6.0 * p2 * px);
                py -= ((1.0 + k1 * (x02 + y02) + k2 * (x02 + y02) * (x02 + y02)) * py + p1 * (x02 + y02 + 2.0 * y02) + 2.0 * p2 * px * py - (iy - y0) / fy) / (1.0 + k1 * (x02 + 3.0 * y02) + k2 * (x02 * x02 + 3.0 * x02 * y02 + 5.0 * y02 * y02) + 6.0 * p1 * py + 2.0 * p2 * px);
            } else {
                px = 0.0;
                py = 0.0;
                break;
            }
            if (i == this.PD_LOOP2) break;
            x02 = px * px;
            y02 = py * py;
            ++i;
        }
        o_point.x = px * fx / this._s + x0;
        o_point.y = py * fy / this._s + y0;
    }

    @Override
    public void observ2Ideal(NyARDoublePoint2d i_in, NyARDoublePoint2d o_point) {
        this.observ2Ideal(i_in.x, i_in.y, o_point);
    }

    @Override
    public void observ2IdealBatch(NyARDoublePoint2d[] i_in, NyARDoublePoint2d[] o_out, int i_size) {
        int i = i_size - 1;
        while (i >= 0) {
            this.observ2Ideal(i_in[i].x, i_in[i].y, o_out[i]);
            --i;
        }
    }
}

