/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.transmat;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.param.INyARCameraDistortionFactor;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.param.NyARPerspectiveProjectionMatrix;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquare;
import jp.nyatla.nyartoolkit.core.transmat.INyARTransMat;
import jp.nyatla.nyartoolkit.core.transmat.NyARRectOffset;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMatResultParam;
import jp.nyatla.nyartoolkit.core.transmat.optimize.NyARPartialDifferentiationOptimize;
import jp.nyatla.nyartoolkit.core.transmat.rotmatrix.NyARRotMatrix;
import jp.nyatla.nyartoolkit.core.transmat.solver.INyARTransportVectorSolver;
import jp.nyatla.nyartoolkit.core.transmat.solver.NyARTransportVectorSolver;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint3d;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix33;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix44;

public class NyARTransMat
implements INyARTransMat {
    private NyARPerspectiveProjectionMatrix _ref_projection_mat;
    protected NyARRotMatrix _rotmatrix;
    protected NyARTransportVectorSolver _transsolver;
    protected NyARPartialDifferentiationOptimize _mat_optimize;
    private INyARCameraDistortionFactor _ref_dist_factor;
    private final NyARDoublePoint2d[] __transMat_vertex_2d = NyARDoublePoint2d.createArray(4);
    private final NyARDoublePoint3d[] __transMat_vertex_3d = NyARDoublePoint3d.createArray(4);
    private final NyARDoublePoint3d __transMat_trans = new NyARDoublePoint3d();

    protected NyARTransMat() {
    }

    private void initInstance(INyARCameraDistortionFactor i_distfactor, NyARPerspectiveProjectionMatrix i_projmat) throws NyARException {
        this._transsolver = new NyARTransportVectorSolver(i_projmat, 4);
        this._rotmatrix = new NyARRotMatrix(i_projmat);
        this._mat_optimize = new NyARPartialDifferentiationOptimize(i_projmat);
        this._ref_dist_factor = i_distfactor;
        this._ref_projection_mat = i_projmat;
    }

    public NyARTransMat(INyARCameraDistortionFactor i_ref_distfactor, NyARPerspectiveProjectionMatrix i_ref_projmat) throws NyARException {
        this.initInstance(i_ref_distfactor, i_ref_projmat);
    }

    public NyARTransMat(NyARParam i_param) throws NyARException {
        this.initInstance(i_param.getDistortionFactor(), i_param.getPerspectiveProjectionMatrix());
    }

    private double makeErrThreshold(NyARDoublePoint2d[] i_vertex) {
        double a = i_vertex[0].x - i_vertex[2].x;
        double b = i_vertex[0].y - i_vertex[2].y;
        double l1 = a * a + b * b;
        double l2 = (a = i_vertex[1].x - i_vertex[3].x) * a + (b = i_vertex[1].y - i_vertex[3].y) * b;
        return Math.sqrt(l1 > l2 ? l1 : l2) / 200.0;
    }

    @Override
    public boolean transMat(NyARSquare i_square, NyARRectOffset i_offset, NyARDoubleMatrix44 o_result, NyARTransMatResultParam o_param) throws NyARException {
        NyARDoublePoint2d[] vertex_2d;
        NyARDoublePoint3d trans = this.__transMat_trans;
        double err_threshold = this.makeErrThreshold(i_square.sqvertex);
        if (this._ref_dist_factor != null) {
            vertex_2d = this.__transMat_vertex_2d;
            this._ref_dist_factor.ideal2ObservBatch(i_square.sqvertex, vertex_2d, 4);
        } else {
            vertex_2d = i_square.sqvertex;
        }
        this._transsolver.set2dVertex(vertex_2d, 4);
        if (!this._rotmatrix.initRotBySquare(i_square.line, i_square.sqvertex)) {
            return false;
        }
        NyARDoublePoint3d[] vertex_3d = this.__transMat_vertex_3d;
        this._rotmatrix.getPoint3dBatch(i_offset.vertex, vertex_3d, 4);
        this._transsolver.solveTransportVector(vertex_3d, trans);
        double err = this.optimize(this._rotmatrix, trans, this._transsolver, i_offset.vertex, vertex_2d, err_threshold, o_result);
        if (o_param != null) {
            o_param.last_error = err;
        }
        return true;
    }

    @Override
    public boolean transMatContinue(NyARSquare i_square, NyARRectOffset i_offset, NyARDoubleMatrix44 i_prev_result, double i_prev_err, NyARDoubleMatrix44 o_result, NyARTransMatResultParam o_param) throws NyARException {
        NyARDoublePoint2d[] vertex_2d;
        NyARDoublePoint3d trans = this.__transMat_trans;
        double err_threshold = this.makeErrThreshold(i_square.sqvertex);
        if (this._ref_dist_factor != null) {
            vertex_2d = this.__transMat_vertex_2d;
            this._ref_dist_factor.ideal2ObservBatch(i_square.sqvertex, vertex_2d, 4);
        } else {
            vertex_2d = i_square.sqvertex;
        }
        this._transsolver.set2dVertex(vertex_2d, 4);
        NyARRotMatrix rot = this._rotmatrix;
        rot.initRotByPrevResult(i_prev_result);
        NyARDoublePoint3d[] vertex_3d = this.__transMat_vertex_3d;
        rot.getPoint3dBatch(i_offset.vertex, vertex_3d, 4);
        this._transsolver.solveTransportVector(vertex_3d, trans);
        double min_err = this.errRate(rot, trans, i_offset.vertex, vertex_2d, 4, vertex_3d);
        if (min_err < i_prev_err + err_threshold) {
            o_result.setValue(rot, trans);
            int i = 0;
            while (i < 5) {
                this._mat_optimize.modifyMatrix(rot, trans, i_offset.vertex, vertex_2d, 4);
                double err = this.errRate(rot, trans, i_offset.vertex, vertex_2d, 4, vertex_3d);
                if (min_err - err < err_threshold / 2.0) break;
                this._transsolver.solveTransportVector(vertex_3d, trans);
                o_result.setValue(rot, trans);
                min_err = err;
                ++i;
            }
            if (o_param != null) {
                o_param.last_error = min_err;
            }
            return true;
        }
        return false;
    }

    private double optimize(NyARRotMatrix iw_rotmat, NyARDoublePoint3d iw_transvec, INyARTransportVectorSolver i_solver, NyARDoublePoint3d[] i_offset_3d, NyARDoublePoint2d[] i_2d_vertex, double i_err_threshold, NyARDoubleMatrix44 o_result) throws NyARException {
        NyARDoublePoint3d[] vertex_3d = this.__transMat_vertex_3d;
        double min_err = this.errRate(iw_rotmat, iw_transvec, i_offset_3d, i_2d_vertex, 4, vertex_3d);
        o_result.setValue(iw_rotmat, iw_transvec);
        int i = 0;
        while (i < 5) {
            this._mat_optimize.modifyMatrix(iw_rotmat, iw_transvec, i_offset_3d, i_2d_vertex, 4);
            double err = this.errRate(iw_rotmat, iw_transvec, i_offset_3d, i_2d_vertex, 4, vertex_3d);
            if (min_err - err < i_err_threshold) break;
            i_solver.solveTransportVector(vertex_3d, iw_transvec);
            o_result.setValue(iw_rotmat, iw_transvec);
            min_err = err;
            ++i;
        }
        return min_err;
    }

    public final double errRate(NyARDoubleMatrix33 i_rot, NyARDoublePoint3d i_trans, NyARDoublePoint3d[] i_vertex3d, NyARDoublePoint2d[] i_vertex2d, int i_number_of_vertex, NyARDoublePoint3d[] o_rot_vertex) throws NyARException {
        NyARPerspectiveProjectionMatrix cp = this._ref_projection_mat;
        double cp00 = cp.m00;
        double cp01 = cp.m01;
        double cp02 = cp.m02;
        double cp11 = cp.m11;
        double cp12 = cp.m12;
        double err = 0.0;
        int i = 0;
        while (i < i_number_of_vertex) {
            double z3d;
            double y3d;
            double x3d;
            o_rot_vertex[i].x = x3d = i_rot.m00 * i_vertex3d[i].x + i_rot.m01 * i_vertex3d[i].y + i_rot.m02 * i_vertex3d[i].z;
            o_rot_vertex[i].y = y3d = i_rot.m10 * i_vertex3d[i].x + i_rot.m11 * i_vertex3d[i].y + i_rot.m12 * i_vertex3d[i].z;
            o_rot_vertex[i].z = z3d = i_rot.m20 * i_vertex3d[i].x + i_rot.m21 * i_vertex3d[i].y + i_rot.m22 * i_vertex3d[i].z;
            double x2d = (x3d += i_trans.x) * cp00 + (y3d += i_trans.y) * cp01 + (z3d += i_trans.z) * cp02;
            double y2d = y3d * cp11 + z3d * cp12;
            double h2d = z3d;
            double t1 = i_vertex2d[i].x - x2d / h2d;
            double t2 = i_vertex2d[i].y - y2d / h2d;
            err += t1 * t1 + t2 * t2;
            ++i;
        }
        return err / (double)i_number_of_vertex;
    }
}

