/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.labeling.rlelabeling;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.labeling.rlelabeling.NyARRleLabelFragmentInfoStack;
import jp.nyatla.nyartoolkit.core.labeling.rlelabeling.RleElement;
import jp.nyatla.nyartoolkit.core.labeling.rlelabeling.RleInfoStack;
import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.raster.NyARBinRaster;
import jp.nyatla.nyartoolkit.core.raster.NyARGrayscaleRaster;

public class NyARLabeling_Rle {
    private static final int AR_AREA_MAX = 100000;
    private static final int AR_AREA_MIN = 70;
    private RleInfoStack _rlestack;
    private RleElement[] _rle1;
    private RleElement[] _rle2;
    private int _max_area;
    private int _min_area;

    public NyARLabeling_Rle(int i_width, int i_height) throws NyARException {
        this._rlestack = new RleInfoStack(i_width * i_height * 2048 / 76800 + 32);
        this._rle1 = RleElement.createArray(i_width / 2 + 1);
        this._rle2 = RleElement.createArray(i_width / 2 + 1);
        this.setAreaRange(100000, 70);
    }

    public void setAreaRange(int i_max, int i_min) {
        this._max_area = i_max;
        this._min_area = i_min;
    }

    private int toRel(int[] i_bin_buf, int i_st, int i_len, RleElement[] i_out, int i_th) {
        int current = 0;
        int r = -1;
        int x = i_st;
        int right_edge = i_st + i_len - 1;
        block0: while (x < right_edge) {
            if (i_bin_buf[x] > i_th) {
                ++x;
                continue;
            }
            r = x - i_st;
            i_out[current].l = r++;
            ++x;
            while (x < right_edge) {
                if (i_bin_buf[x] > i_th) {
                    i_out[current].r = r;
                    ++current;
                    ++x;
                    r = -1;
                    continue block0;
                }
                ++r;
                ++x;
            }
        }
        if (i_bin_buf[x] > i_th) {
            if (r >= 0) {
                i_out[current].r = r;
                ++current;
            }
        } else {
            if (r >= 0) {
                i_out[current].r = r + 1;
            } else {
                i_out[current].l = i_len - 1;
                i_out[current].r = i_len;
            }
            ++current;
        }
        return current;
    }

    private void addFragment(RleElement i_rel_img, int i_nof, int i_row_index, RleInfoStack o_stack) throws NyARException {
        int l = i_rel_img.l;
        int len = i_rel_img.r - l;
        i_rel_img.fid = i_nof;
        RleInfoStack.RleInfo v = (RleInfoStack.RleInfo)o_stack.prePush();
        v.entry_x = l;
        v.area = len;
        v.clip_l = l;
        v.clip_r = i_rel_img.r - 1;
        v.clip_t = i_row_index;
        v.clip_b = i_row_index;
        v.pos_x = len * (2 * l + (len - 1)) / 2;
        v.pos_y = i_row_index * len;
    }

    public int labeling(NyARBinRaster i_bin_raster, int i_top, int i_bottom, NyARRleLabelFragmentInfoStack o_stack) throws NyARException {
        assert (i_bin_raster.isEqualBufferType(262146));
        return this.imple_labeling(i_bin_raster, 0, i_top, i_bottom, o_stack);
    }

    public int labeling(NyARGrayscaleRaster i_gs_raster, int i_th, int i_top, int i_bottom, NyARRleLabelFragmentInfoStack o_stack) throws NyARException {
        assert (i_gs_raster.isEqualBufferType(262145));
        return this.imple_labeling(i_gs_raster, i_th, i_top, i_bottom, o_stack);
    }

    private int imple_labeling(INyARRaster i_raster, int i_th, int i_top, int i_bottom, NyARRleLabelFragmentInfoStack o_stack) throws NyARException {
        RleInfoStack rlestack = this._rlestack;
        rlestack.clear();
        RleElement[] rle_prev = this._rle1;
        RleElement[] rle_current = this._rle2;
        int len_prev = 0;
        int len_current = 0;
        int width = i_raster.getWidth();
        int[] in_buf = (int[])i_raster.getBuffer();
        int id_max = 0;
        int label_count = 0;
        len_prev = this.toRel(in_buf, i_top, width, rle_prev, i_th);
        int i = 0;
        while (i < len_prev) {
            this.addFragment(rle_prev[i], id_max, i_top, rlestack);
            ++id_max;
            ++label_count;
            ++i;
        }
        RleInfoStack.RleInfo[] f_array = (RleInfoStack.RleInfo[])rlestack.getArray();
        int y = i_top + 1;
        while (y < i_bottom) {
            len_current = this.toRel(in_buf, y * width, width, rle_current, i_th);
            int index_prev = 0;
            int i2 = 0;
            while (i2 < len_current) {
                block21: {
                    int id = -1;
                    block3: while (index_prev < len_prev) {
                        if (rle_current[i2].l - rle_prev[index_prev].r > 0) {
                            ++index_prev;
                            continue;
                        }
                        if (rle_prev[index_prev].l - rle_current[i2].r > 0) {
                            this.addFragment(rle_current[i2], id_max, y, rlestack);
                            ++id_max;
                            ++label_count;
                            break block21;
                        }
                        id = rle_prev[index_prev].fid;
                        RleInfoStack.RleInfo id_ptr = f_array[id];
                        rle_current[i2].fid = id;
                        int l = rle_current[i2].l;
                        int r = rle_current[i2].r;
                        int len = r - l;
                        id_ptr.area += len;
                        id_ptr.clip_l = l < id_ptr.clip_l ? l : id_ptr.clip_l;
                        id_ptr.clip_r = r > id_ptr.clip_r ? r - 1 : id_ptr.clip_r;
                        id_ptr.clip_b = y;
                        id_ptr.pos_x += (long)(len * (2 * l + (len - 1)) / 2);
                        id_ptr.pos_y += (long)(y * len);
                        ++index_prev;
                        while (index_prev < len_prev) {
                            if (rle_current[i2].l - rle_prev[index_prev].r > 0) break block3;
                            if (rle_prev[index_prev].l - rle_current[i2].r > 0) {
                                --index_prev;
                                break block21;
                            }
                            int prev_id = rle_prev[index_prev].fid;
                            RleInfoStack.RleInfo prev_ptr = f_array[prev_id];
                            if (id != prev_id) {
                                --label_count;
                                int i22 = index_prev;
                                while (i22 < len_prev) {
                                    if (rle_prev[i22].fid == prev_id) {
                                        rle_prev[i22].fid = id;
                                    }
                                    ++i22;
                                }
                                i22 = 0;
                                while (i22 < i2) {
                                    if (rle_current[i22].fid == prev_id) {
                                        rle_current[i22].fid = id;
                                    }
                                    ++i22;
                                }
                                id_ptr.area += prev_ptr.area;
                                id_ptr.pos_x += prev_ptr.pos_x;
                                id_ptr.pos_y += prev_ptr.pos_y;
                                if (id_ptr.clip_t > prev_ptr.clip_t) {
                                    id_ptr.clip_t = prev_ptr.clip_t;
                                    id_ptr.entry_x = prev_ptr.entry_x;
                                } else if (id_ptr.clip_t >= prev_ptr.clip_t && id_ptr.entry_x > prev_ptr.entry_x) {
                                    id_ptr.entry_x = prev_ptr.entry_x;
                                }
                                if (id_ptr.clip_l > prev_ptr.clip_l) {
                                    id_ptr.clip_l = prev_ptr.clip_l;
                                }
                                if (id_ptr.clip_r < prev_ptr.clip_r) {
                                    id_ptr.clip_r = prev_ptr.clip_r;
                                }
                                prev_ptr.area = 0;
                            }
                            ++index_prev;
                        }
                        --index_prev;
                        break;
                    }
                    if (id < 0) {
                        this.addFragment(rle_current[i2], id_max, y, rlestack);
                        ++id_max;
                        ++label_count;
                    }
                }
                ++i2;
            }
            RleElement[] tmp = rle_prev;
            rle_prev = rle_current;
            len_prev = len_current;
            rle_current = tmp;
            ++y;
        }
        o_stack.init(label_count);
        NyARRleLabelFragmentInfoStack.RleLabelFragmentInfo[] o_dest_array = (NyARRleLabelFragmentInfoStack.RleLabelFragmentInfo[])o_stack.getArray();
        int max = this._max_area;
        int min = this._min_area;
        int active_labels = 0;
        int i3 = id_max - 1;
        while (i3 >= 0) {
            int area = f_array[i3].area;
            if (area >= min && area <= max) {
                RleInfoStack.RleInfo src_info = f_array[i3];
                NyARRleLabelFragmentInfoStack.RleLabelFragmentInfo dest_info = o_dest_array[active_labels];
                dest_info.area = area;
                dest_info.clip_b = src_info.clip_b;
                dest_info.clip_r = src_info.clip_r;
                dest_info.clip_t = src_info.clip_t;
                dest_info.clip_l = src_info.clip_l;
                dest_info.entry_x = src_info.entry_x;
                dest_info.pos_x = src_info.pos_x / (long)src_info.area;
                dest_info.pos_y = src_info.pos_y / (long)src_info.area;
                ++active_labels;
            }
            --i3;
        }
        o_stack.pops(label_count - active_labels);
        return active_labels;
    }
}

