/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.param;

import jp.nyatla.nyartoolkit.core.param.INyARCameraDistortionFactor;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;

public class NyARCameraDistortionFactor
implements INyARCameraDistortionFactor {
    private static final int PD_LOOP = 3;
    private double _f0;
    private double _f1;
    private double _f2;
    private double _f3;

    public void copyFrom(NyARCameraDistortionFactor i_ref) {
        this._f0 = i_ref._f0;
        this._f1 = i_ref._f1;
        this._f2 = i_ref._f2;
        this._f3 = i_ref._f3;
    }

    public void setValue(double[] i_factor) {
        this._f0 = i_factor[0];
        this._f1 = i_factor[1];
        this._f2 = i_factor[2];
        this._f3 = i_factor[3];
    }

    public void getValue(double[] o_factor) {
        o_factor[0] = this._f0;
        o_factor[1] = this._f1;
        o_factor[2] = this._f2;
        o_factor[3] = this._f3;
    }

    public void changeScale(double i_scale) {
        this._f0 *= i_scale;
        this._f1 *= i_scale;
        this._f2 /= i_scale * i_scale;
    }

    public void ideal2Observ(NyARDoublePoint2d i_in, NyARDoublePoint2d o_out) {
        double x = (i_in.x - this._f0) * this._f3;
        double y = (i_in.y - this._f1) * this._f3;
        if (x == 0.0 && y == 0.0) {
            o_out.x = this._f0;
            o_out.y = this._f1;
        } else {
            double d = 1.0 - this._f2 / 1.0E8 * (x * x + y * y);
            o_out.x = x * d + this._f0;
            o_out.y = y * d + this._f1;
        }
    }

    public void ideal2ObservBatch(NyARDoublePoint2d[] i_in, NyARDoublePoint2d[] o_out, int i_size) {
        double d0 = this._f0;
        double d1 = this._f1;
        double d3 = this._f3;
        double d2_w = this._f2 / 1.0E8;
        int i = 0;
        while (i < i_size) {
            double x = (i_in[i].x - d0) * d3;
            double y = (i_in[i].y - d1) * d3;
            if (x == 0.0 && y == 0.0) {
                o_out[i].x = d0;
                o_out[i].y = d1;
            } else {
                double d = 1.0 - d2_w * (x * x + y * y);
                o_out[i].x = x * d + d0;
                o_out[i].y = y * d + d1;
            }
            ++i;
        }
    }

    public void observ2Ideal(double ix, double iy, NyARDoublePoint2d o_point) {
        double z0;
        double d0 = this._f0;
        double d1 = this._f1;
        double px = ix - d0;
        double py = iy - d1;
        double p = this._f2 / 1.0E8;
        double z02 = px * px + py * py;
        double q = z0 = Math.sqrt(z02);
        int i = 1;
        while (true) {
            if (z0 == 0.0) {
                px = 0.0;
                py = 0.0;
                break;
            }
            double opttmp_1 = p * z02;
            double z = z0 - ((1.0 - opttmp_1) * z0 - q) / (1.0 - 3.0 * opttmp_1);
            px = px * z / z0;
            py = py * z / z0;
            if (i == 3) break;
            z02 = px * px + py * py;
            z0 = Math.sqrt(z02);
            ++i;
        }
        o_point.x = px / this._f3 + d0;
        o_point.y = py / this._f3 + d1;
    }

    public void observ2IdealBatch(int[] i_x_coord, int[] i_y_coord, int i_start, int i_num, double[] o_x_coord, double[] o_y_coord) {
        double d0 = this._f0;
        double d1 = this._f1;
        double d3 = this._f3;
        double p = this._f2 / 1.0E8;
        int j = 0;
        while (j < i_num) {
            double z0;
            double px = (double)i_x_coord[i_start + j] - d0;
            double py = (double)i_y_coord[i_start + j] - d1;
            double z02 = px * px + py * py;
            double q = z0 = Math.sqrt(z02);
            int i = 1;
            while (true) {
                if (z0 == 0.0) {
                    px = 0.0;
                    py = 0.0;
                    break;
                }
                double opttmp_1 = p * z02;
                double z = z0 - ((1.0 - opttmp_1) * z0 - q) / (1.0 - 3.0 * opttmp_1);
                px = px * z / z0;
                py = py * z / z0;
                if (i == 3) break;
                z02 = px * px + py * py;
                z0 = Math.sqrt(z02);
                ++i;
            }
            o_x_coord[j] = px / d3 + d0;
            o_y_coord[j] = py / d3 + d1;
            ++j;
        }
    }
}

