/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.squaredetect;

import jp.nyatla.nyartoolkit.core.squaredetect.NyARVertexCounter;

public class NyARCoord2SquareVertexIndexes {
    private static final double VERTEX_FACTOR = 1.0;
    private final NyARVertexCounter __getSquareVertex_wv1 = new NyARVertexCounter();
    private final NyARVertexCounter __getSquareVertex_wv2 = new NyARVertexCounter();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getVertexIndexes(int[] i_x_coord, int[] i_y_coord, int i_coord_num, int i_area, int[] o_vertex) {
        NyARVertexCounter wv1 = this.__getSquareVertex_wv1;
        NyARVertexCounter wv2 = this.__getSquareVertex_wv2;
        int vertex1_index = NyARCoord2SquareVertexIndexes.getFarPoint(i_x_coord, i_y_coord, i_coord_num, 0);
        int prev_vertex_index = (vertex1_index + i_coord_num) % i_coord_num;
        int v1 = NyARCoord2SquareVertexIndexes.getFarPoint(i_x_coord, i_y_coord, i_coord_num, vertex1_index);
        double thresh = (double)i_area / 0.75 * 0.01 * 1.0;
        o_vertex[0] = vertex1_index;
        if (!wv1.getVertex(i_x_coord, i_y_coord, i_coord_num, vertex1_index, v1, thresh)) {
            return false;
        }
        if (!wv2.getVertex(i_x_coord, i_y_coord, i_coord_num, v1, prev_vertex_index, thresh)) {
            return false;
        }
        if (wv1.number_of_vertex == 1 && wv2.number_of_vertex == 1) {
            o_vertex[1] = wv1.vertex[0];
            o_vertex[2] = v1;
            o_vertex[3] = wv2.vertex[0];
            return true;
        } else if (wv1.number_of_vertex > 1 && wv2.number_of_vertex == 0) {
            int v2 = v1 >= vertex1_index ? (v1 - vertex1_index) / 2 + vertex1_index : ((v1 + i_coord_num - vertex1_index) / 2 + vertex1_index) % i_coord_num;
            if (!wv1.getVertex(i_x_coord, i_y_coord, i_coord_num, vertex1_index, v2, thresh)) {
                return false;
            }
            if (!wv2.getVertex(i_x_coord, i_y_coord, i_coord_num, v2, v1, thresh)) {
                return false;
            }
            if (wv1.number_of_vertex != 1 || wv2.number_of_vertex != 1) return false;
            o_vertex[1] = wv1.vertex[0];
            o_vertex[2] = wv2.vertex[0];
            o_vertex[3] = v1;
            return true;
        } else {
            if (wv1.number_of_vertex != 0 || wv2.number_of_vertex <= 1) return false;
            int v2 = v1 <= prev_vertex_index ? (v1 + prev_vertex_index) / 2 : (v1 + i_coord_num + prev_vertex_index) / 2 % i_coord_num;
            if (!wv1.getVertex(i_x_coord, i_y_coord, i_coord_num, v1, v2, thresh)) {
                return false;
            }
            if (!wv2.getVertex(i_x_coord, i_y_coord, i_coord_num, v2, prev_vertex_index, thresh)) {
                return false;
            }
            if (wv1.number_of_vertex != 1 || wv2.number_of_vertex != 1) return false;
            o_vertex[1] = v1;
            o_vertex[2] = wv1.vertex[0];
            o_vertex[3] = wv2.vertex[0];
        }
        return true;
    }

    private static int getFarPoint(int[] i_coord_x, int[] i_coord_y, int i_coord_num, int i_point) {
        int w;
        int y;
        int x;
        int sx = i_coord_x[i_point];
        int sy = i_coord_y[i_point];
        int d = 0;
        int ret = 0;
        int i = i_point + 1;
        while (i < i_coord_num) {
            x = i_coord_x[i] - sx;
            y = i_coord_y[i] - sy;
            w = x * x + y * y;
            if (w > d) {
                d = w;
                ret = i;
            }
            ++i;
        }
        i = 0;
        while (i < i_point) {
            x = i_coord_x[i] - sx;
            y = i_coord_y[i] - sy;
            w = x * x + y * y;
            if (w > d) {
                d = w;
                ret = i;
            }
            ++i;
        }
        return ret;
    }
}

