/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.sample;

import java.io.File;
import java.io.FileInputStream;
import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARCode;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.raster.rgb.NyARRgbRaster_BGRA;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquare;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMatResult;
import jp.nyatla.nyartoolkit.processor.SingleARMarkerProcesser;

public class SingleARMarkerTest {
    private static final String CARCODE_FILE = "../Data/patt.hiro";
    private static final String PARAM_FILE = "../Data/camera_para.dat";
    private final String data_file = "../Data/320x240ABGR.raw";

    public void Test() throws Exception {
        NyARParam ap = new NyARParam();
        ap.loadARParamFromFile(PARAM_FILE);
        ap.changeScreenSize(320, 240);
        File f = new File("../Data/320x240ABGR.raw");
        FileInputStream fs = new FileInputStream("../Data/320x240ABGR.raw");
        byte[] buf = new byte[(int)f.length()];
        fs.read(buf);
        NyARRgbRaster_BGRA ra = new NyARRgbRaster_BGRA(320, 240, false);
        ra.wrapBuffer(buf);
        MarkerProcessor pr = new MarkerProcessor(ap, ra.getBufferType());
        NyARCode[] codes = new NyARCode[]{new NyARCode(16, 16)};
        codes[0].loadARPattFromFile(CARCODE_FILE);
        pr.setARCodeTable(codes, 16, 80.0);
        pr.detectMarker(ra);
    }

    public static void main(String[] args) {
        try {
            SingleARMarkerTest t = new SingleARMarkerTest();
            t.Test();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class MarkerProcessor
    extends SingleARMarkerProcesser {
        private Object _sync_object = new Object();
        public NyARTransMatResult transmat = null;
        public int current_code = -1;

        public MarkerProcessor(NyARParam i_cparam, int i_raster_format) throws NyARException {
            this.initInstance(i_cparam, i_raster_format);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onEnterHandler(int i_code) {
            Object object = this._sync_object;
            synchronized (object) {
                this.current_code = i_code;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onLeaveHandler() {
            Object object = this._sync_object;
            synchronized (object) {
                this.current_code = -1;
                this.transmat = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onUpdateHandler(NyARSquare i_square, NyARTransMatResult result) {
            Object object = this._sync_object;
            synchronized (object) {
                this.transmat = result;
            }
        }
    }
}

