/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARMarker;

public class NyARMarkerList {
    private int marker_holder_num;
    protected int marker_array_num;
    protected final NyARMarker[] marker_holder;
    protected final NyARMarker[] marker_array;

    protected NyARMarkerList(NyARMarker[] i_holder) {
        this.marker_holder = i_holder;
        this.marker_array = new NyARMarker[i_holder.length];
        this.marker_array_num = 0;
        this.marker_holder_num = 0;
    }

    public NyARMarkerList(int i_number_of_holder) {
        this.marker_holder = new NyARMarker[i_number_of_holder];
        for (int i = 0; i < i_number_of_holder; ++i) {
            this.marker_holder[i] = new NyARMarker();
        }
        this.marker_array = new NyARMarker[this.marker_holder.length];
        this.marker_array_num = 0;
        this.marker_holder_num = 0;
    }

    public final NyARMarker getCurrentHolder() throws NyARException {
        if (this.marker_holder_num >= this.marker_holder.length) {
            throw new NyARException();
        }
        return this.marker_holder[this.marker_holder_num];
    }

    public final NyARMarker getNextHolder() {
        if (this.marker_holder_num + 1 >= this.marker_holder.length) {
            this.marker_holder_num = this.marker_holder.length;
            return null;
        }
        ++this.marker_holder_num;
        return this.marker_holder[this.marker_holder_num];
    }

    public final NyARMarker getMarker(int i_index) throws NyARException {
        if (i_index >= this.marker_array_num) {
            throw new NyARException();
        }
        return this.marker_array[i_index];
    }

    public final int getMarkerNum() {
        return this.marker_array_num;
    }

    public final void reset() {
        this.marker_array_num = 0;
        this.marker_holder_num = 0;
    }

    public final void updateMarkerArray() {
        int i;
        for (i = 0; i < this.marker_holder_num; ++i) {
            double[] pos_i = this.marker_holder[i].pos;
            for (int j = i + 1; j < this.marker_holder_num; ++j) {
                double[] pos_j = this.marker_holder[j].pos;
                double d = (pos_i[0] - pos_j[0]) * (pos_i[0] - pos_j[0]) + (pos_i[1] - pos_j[1]) * (pos_i[1] - pos_j[1]);
                if (this.marker_holder[i].area > this.marker_holder[j].area) {
                    if (!(d < (double)(this.marker_holder[i].area / 4))) continue;
                    this.marker_holder[j].area = 0;
                    continue;
                }
                if (!(d < (double)(this.marker_holder[j].area / 4))) continue;
                this.marker_holder[i].area = 0;
            }
        }
        int l_array_num = 0;
        for (i = 0; i < this.marker_holder_num; ++i) {
            if ((double)this.marker_holder[i].area == 0.0) continue;
            this.marker_array[l_array_num] = this.marker_holder[i];
            ++l_array_num;
        }
        this.marker_array_num = l_array_num;
    }
}

