/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARParam;
import jp.nyatla.nyartoolkit.core.NyARSquare;
import jp.nyatla.nyartoolkit.core.NyARTransRot_OptimizeCommon;

class NyARTransRot_O1
extends NyARTransRot_OptimizeCommon {
    private final double[] wk_arModifyMatrix_combo = new double[12];
    private final double[] wk_arModifyMatrix_abc = new double[3];
    private final double[] wk_arModifyMatrix_rot = new double[9];
    private final double[] wk_cpara2_arGetNewMatrix = new double[12];

    public NyARTransRot_O1(NyARParam i_param, int i_number_of_vertex) throws NyARException {
        super(i_param, i_number_of_vertex);
    }

    @Override
    public final void initRot(NyARSquare marker_info, int i_direction) throws NyARException {
        double w;
        double[] cpara = this.cparam.get34Array();
        double[][] wdir = new double[3][3];
        int dir = i_direction;
        for (int j = 0; j < 2; ++j) {
            double w1 = marker_info.line[(4 - dir + j) % 4][0] * marker_info.line[(6 - dir + j) % 4][1] - marker_info.line[(6 - dir + j) % 4][0] * marker_info.line[(4 - dir + j) % 4][1];
            double w2 = marker_info.line[(4 - dir + j) % 4][1] * marker_info.line[(6 - dir + j) % 4][2] - marker_info.line[(6 - dir + j) % 4][1] * marker_info.line[(4 - dir + j) % 4][2];
            double w3 = marker_info.line[(4 - dir + j) % 4][2] * marker_info.line[(6 - dir + j) % 4][0] - marker_info.line[(6 - dir + j) % 4][2] * marker_info.line[(4 - dir + j) % 4][0];
            wdir[j][0] = w1 * (cpara[1] * cpara[6] - cpara[2] * cpara[5]) + w2 * cpara[5] - w3 * cpara[1];
            wdir[j][1] = -w1 * cpara[0] * cpara[6] + w3 * cpara[0];
            wdir[j][2] = w1 * cpara[0] * cpara[5];
            w = Math.sqrt(wdir[j][0] * wdir[j][0] + wdir[j][1] * wdir[j][1] + wdir[j][2] * wdir[j][2]);
            double[] dArray = wdir[j];
            dArray[0] = dArray[0] / w;
            double[] dArray2 = wdir[j];
            dArray2[1] = dArray2[1] / w;
            double[] dArray3 = wdir[j];
            dArray3[2] = dArray3[2] / w;
        }
        this.check_dir(wdir[0], marker_info.sqvertex[(4 - dir) % 4], marker_info.sqvertex[(5 - dir) % 4], cpara);
        this.check_dir(wdir[1], marker_info.sqvertex[(7 - dir) % 4], marker_info.sqvertex[(4 - dir) % 4], cpara);
        NyARTransRot_O1.check_rotation(wdir);
        wdir[2][0] = wdir[0][1] * wdir[1][2] - wdir[0][2] * wdir[1][1];
        wdir[2][1] = wdir[0][2] * wdir[1][0] - wdir[0][0] * wdir[1][2];
        wdir[2][2] = wdir[0][0] * wdir[1][1] - wdir[0][1] * wdir[1][0];
        w = Math.sqrt(wdir[2][0] * wdir[2][0] + wdir[2][1] * wdir[2][1] + wdir[2][2] * wdir[2][2]);
        double[] dArray = wdir[2];
        dArray[0] = dArray[0] / w;
        double[] dArray4 = wdir[2];
        dArray4[1] = dArray4[1] / w;
        double[] dArray5 = wdir[2];
        dArray5[2] = dArray5[2] / w;
        double[] rot = this.array;
        rot[0] = wdir[0][0];
        rot[3] = wdir[0][1];
        rot[6] = wdir[0][2];
        rot[1] = wdir[1][0];
        rot[4] = wdir[1][1];
        rot[7] = wdir[1][2];
        rot[2] = wdir[2][0];
        rot[5] = wdir[2][1];
        rot[8] = wdir[2][2];
    }

    @Override
    public final double modifyMatrix(double[] trans, double[][] vertex, double[][] pos2d) throws NyARException {
        int num = this.number_of_vertex;
        double ma = 0.0;
        double mb = 0.0;
        double mc = 0.0;
        double minerr = 0.0;
        int s1 = 0;
        int s2 = 0;
        int s3 = 0;
        double[] combo = this.wk_arModifyMatrix_combo;
        double[] abc = this.wk_arModifyMatrix_abc;
        double[] rot = this.wk_arModifyMatrix_rot;
        this.arGetAngle(abc);
        double a2 = abc[0];
        double b2 = abc[1];
        double c2 = abc[2];
        double factor = 0.17453292519943295;
        for (int j = 0; j < 10; ++j) {
            minerr = 1.0E9;
            for (int t1 = -1; t1 <= 1; ++t1) {
                for (int t2 = -1; t2 <= 1; ++t2) {
                    for (int t3 = -1; t3 <= 1; ++t3) {
                        double a1 = a2 + factor * (double)t1;
                        double b1 = b2 + factor * (double)t2;
                        double c1 = c2 + factor * (double)t3;
                        NyARTransRot_O1.arGetRot(a1, b1, c1, rot);
                        this.arGetNewMatrix(rot, trans, null, combo);
                        double err = 0.0;
                        for (int i = 0; i < num; ++i) {
                            double hx = combo[0] * vertex[i][0] + combo[1] * vertex[i][1] + combo[2] * vertex[i][2] + combo[3];
                            double hy = combo[4] * vertex[i][0] + combo[5] * vertex[i][1] + combo[6] * vertex[i][2] + combo[7];
                            double h = combo[8] * vertex[i][0] + combo[9] * vertex[i][1] + combo[10] * vertex[i][2] + combo[11];
                            double x = hx / h;
                            double y = hy / h;
                            err += (pos2d[i][0] - x) * (pos2d[i][0] - x) + (pos2d[i][1] - y) * (pos2d[i][1] - y);
                        }
                        if (!(err < minerr)) continue;
                        minerr = err;
                        ma = a1;
                        mb = b1;
                        mc = c1;
                        s1 = t1;
                        s2 = t2;
                        s3 = t3;
                    }
                }
            }
            if (s1 == 0 && s2 == 0 && s3 == 0) {
                factor *= 0.5;
            }
            a2 = ma;
            b2 = mb;
            c2 = mc;
        }
        NyARTransRot_O1.arGetRot(ma, mb, mc, this.array);
        return minerr / (double)num;
    }

    private final int arGetNewMatrix(double[] i_rot, double[] trans, double[][] trans2, double[] ret) throws NyARException {
        int j;
        double[] cpara2;
        double[] cpara = this.cparam.get34Array();
        if (trans2 != null) {
            cpara2 = this.wk_cpara2_arGetNewMatrix;
            for (j = 0; j < 3; ++j) {
                NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
                cpara2[j * 4 + 0] = cpara[j * 4 + 0] * trans2[0][0] + cpara[j * 4 + 1] * trans2[1][0] + cpara[j * 4 + 2] * trans2[2][0];
                cpara2[j * 4 + 1] = cpara[j * 4 + 0] * trans2[0][1] + cpara[j * 4 + 1] * trans2[1][1] + cpara[j * 4 + 2] * trans2[2][1];
                cpara2[j * 4 + 2] = cpara[j * 4 + 0] * trans2[0][2] + cpara[j * 4 + 1] * trans2[1][2] + cpara[j * 4 + 2] * trans2[2][2];
                cpara2[j * 4 + 3] = cpara[j * 4 + 0] * trans2[0][3] + cpara[j * 4 + 1] * trans2[1][3] + cpara[j * 4 + 2] * trans2[2][3];
            }
        } else {
            cpara2 = cpara;
        }
        for (j = 0; j < 3; ++j) {
            int j_idx = j * 4;
            ret[j_idx + 0] = cpara2[j_idx + 0] * i_rot[0] + cpara2[j_idx + 1] * i_rot[3] + cpara2[j_idx + 2] * i_rot[6];
            ret[j_idx + 1] = cpara2[j_idx + 0] * i_rot[1] + cpara2[j_idx + 1] * i_rot[4] + cpara2[j_idx + 2] * i_rot[7];
            ret[j_idx + 2] = cpara2[j_idx + 0] * i_rot[2] + cpara2[j_idx + 1] * i_rot[5] + cpara2[j_idx + 2] * i_rot[8];
            ret[j_idx + 3] = cpara2[j_idx + 0] * trans[0] + cpara2[j_idx + 1] * trans[1] + cpara2[j_idx + 2] * trans[2] + cpara2[j_idx + 3];
        }
        return 0;
    }
}

