/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.detector;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARCode;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPattDeviationColorData;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPattResult;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPatt_Color_WITHOUT_PCA;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.pickup.INyARColorPatt;
import jp.nyatla.nyartoolkit.core.raster.NyARBinRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.rgb2bin.INyARRasterFilter_Rgb2Bin;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARCoord2Linear;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquare;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquareContourDetector;
import jp.nyatla.nyartoolkit.core.transmat.INyARTransMat;
import jp.nyatla.nyartoolkit.core.transmat.NyARRectOffset;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMatResult;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.core.types.NyARLinear;

public class NyARCustomSingleDetectMarker {
    private boolean _is_continue = false;
    private NyARSquareContourDetector _square_detect;
    protected INyARTransMat _transmat;
    private NyARBinRaster _bin_raster;
    protected INyARRasterFilter_Rgb2Bin _tobin_filter;
    private DetectSquareCB _detect_cb;
    private NyARRectOffset _offset;

    protected NyARCustomSingleDetectMarker() {
    }

    protected void initInstance(INyARColorPatt i_patt_inst, NyARSquareContourDetector i_sqdetect_inst, INyARTransMat i_transmat_inst, INyARRasterFilter_Rgb2Bin i_filter, NyARParam i_ref_param, NyARCode i_ref_code, double i_marker_width) throws NyARException {
        NyARIntSize scr_size = i_ref_param.getScreenSize();
        this._square_detect = i_sqdetect_inst;
        this._transmat = i_transmat_inst;
        this._tobin_filter = i_filter;
        this._bin_raster = new NyARBinRaster(scr_size.w, scr_size.h);
        this._detect_cb = new DetectSquareCB(i_patt_inst, i_ref_code, i_ref_param);
        this._offset = new NyARRectOffset();
        this._offset.setSquare(i_marker_width);
    }

    public boolean detectMarkerLite(INyARRgbRaster i_raster) throws NyARException {
        if (!this._bin_raster.getSize().isEqualSize(i_raster.getSize())) {
            throw new NyARException();
        }
        this._tobin_filter.doFilter(i_raster, this._bin_raster);
        this._detect_cb.init(i_raster);
        this._square_detect.detectMarkerCB(this._bin_raster, this._detect_cb);
        return this._detect_cb.confidence != 0.0;
    }

    public void getTransmationMatrix(NyARTransMatResult o_result) throws NyARException {
        if (this._is_continue) {
            this._transmat.transMatContinue(this._detect_cb.square, this._offset, o_result);
        } else {
            this._transmat.transMat(this._detect_cb.square, this._offset, o_result);
        }
    }

    public NyARSquare refSquare() {
        return this._detect_cb.square;
    }

    public double getConfidence() {
        return this._detect_cb.confidence;
    }

    public void setContinueMode(boolean i_is_continue) {
        this._is_continue = i_is_continue;
    }

    private class DetectSquareCB
    implements NyARSquareContourDetector.IDetectMarkerCallback {
        public double confidence;
        public NyARSquare square = new NyARSquare();
        private INyARRgbRaster _ref_raster;
        private INyARColorPatt _inst_patt;
        private NyARMatchPattDeviationColorData _deviation_data;
        private NyARMatchPatt_Color_WITHOUT_PCA _match_patt;
        private final NyARMatchPattResult __detectMarkerLite_mr = new NyARMatchPattResult();
        private NyARCoord2Linear _coordline;
        private NyARIntPoint2d[] __tmp_vertex = NyARIntPoint2d.createArray(4);

        public DetectSquareCB(INyARColorPatt i_inst_patt, NyARCode i_ref_code, NyARParam i_param) {
            this._inst_patt = i_inst_patt;
            this._deviation_data = new NyARMatchPattDeviationColorData(i_ref_code.getWidth(), i_ref_code.getHeight());
            this._coordline = new NyARCoord2Linear(i_param.getScreenSize(), i_param.getDistortionFactor());
            this._match_patt = new NyARMatchPatt_Color_WITHOUT_PCA(i_ref_code);
        }

        public void onSquareDetect(NyARSquareContourDetector i_sender, int[] i_coordx, int[] i_coordy, int i_coor_num, int[] i_vertex_index) throws NyARException {
            NyARMatchPattResult mr = this.__detectMarkerLite_mr;
            NyARIntPoint2d[] vertex = this.__tmp_vertex;
            vertex[0].x = i_coordx[i_vertex_index[0]];
            vertex[0].y = i_coordy[i_vertex_index[0]];
            vertex[1].x = i_coordx[i_vertex_index[1]];
            vertex[1].y = i_coordy[i_vertex_index[1]];
            vertex[2].x = i_coordx[i_vertex_index[2]];
            vertex[2].y = i_coordy[i_vertex_index[2]];
            vertex[3].x = i_coordx[i_vertex_index[3]];
            vertex[3].y = i_coordy[i_vertex_index[3]];
            if (!this._inst_patt.pickFromRaster(this._ref_raster, vertex)) {
                return;
            }
            this._deviation_data.setRaster(this._inst_patt);
            if (!this._match_patt.evaluate(this._deviation_data, mr)) {
                return;
            }
            if (this.confidence > mr.confidence) {
                return;
            }
            NyARSquare sq = this.square;
            this.confidence = mr.confidence;
            int i = 0;
            while (i < 4) {
                int idx = (i + 4 - mr.direction) % 4;
                this._coordline.coord2Line(i_vertex_index[idx], i_vertex_index[(idx + 1) % 4], i_coordx, i_coordy, i_coor_num, sq.line[i]);
                ++i;
            }
            i = 0;
            while (i < 4) {
                if (!NyARLinear.crossPos(sq.line[i], sq.line[(i + 3) % 4], sq.sqvertex[i])) {
                    throw new NyARException();
                }
                ++i;
            }
        }

        public final void init(INyARRgbRaster i_raster) {
            this.confidence = 0.0;
            this._ref_raster = i_raster;
        }
    }
}

