/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.pickup;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARMat;
import jp.nyatla.nyartoolkit.core.pickup.INyARColorPatt;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterreader.INyARRgbPixelReader;
import jp.nyatla.nyartoolkit.core.rasterreader.NyARRgbPixelReader_INT1D_X8R8G8B8_32;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARColorPatt_O3
implements INyARColorPatt {
    private static final int AR_PATT_SAMPLE_NUM = 64;
    private static final int BUFFER_FORMAT = 262402;
    private int[] _patdata;
    private NyARIntSize _size;
    private NyARRgbPixelReader_INT1D_X8R8G8B8_32 _pixelreader;
    private final NyARMat wk_get_cpara_a = new NyARMat(8, 8);
    private final NyARMat wk_get_cpara_b = new NyARMat(8, 1);
    private final NyARMat wk_pickFromRaster_cpara = new NyARMat(8, 1);
    private static final int[][] wk_pickFromRaster_world = new int[][]{{100, 100}, {110, 100}, {110, 110}, {100, 110}};
    private int[] __updateExtpat_rgbset;
    private int[] __updateExtpat_xc;
    private int[] __updateExtpat_yc;
    private double[] __updateExtpat_xw;
    private double[] __updateExtpat_yw;
    private int _last_pix_resolution_x = 0;
    private int _last_pix_resolution_y = 0;
    private static double LT_POS = 102.5;
    private static double SQ_SIZE = 5.0;

    public NyARColorPatt_O3(int i_width, int i_height) {
        this._size = new NyARIntSize(i_width, i_height);
        this._patdata = new int[i_height * i_width];
        this._pixelreader = new NyARRgbPixelReader_INT1D_X8R8G8B8_32(this._patdata, this._size);
    }

    public int getWidth() {
        return this._size.w;
    }

    public int getHeight() {
        return this._size.h;
    }

    public NyARIntSize getSize() {
        return this._size;
    }

    public INyARRgbPixelReader getRgbPixelReader() {
        return this._pixelreader;
    }

    public Object getBuffer() {
        return this._patdata;
    }

    public boolean hasBuffer() {
        return this._patdata != null;
    }

    public void wrapBuffer(Object i_ref_buf) throws NyARException {
        NyARException.notImplement();
    }

    public final int getBufferType() {
        return 262402;
    }

    public final boolean isEqualBufferType(int i_type_value) {
        return 262402 == i_type_value;
    }

    private boolean get_cpara(NyARIntPoint2d[] i_vertex, NyARMat o_para) throws NyARException {
        int[][] world = wk_pickFromRaster_world;
        NyARMat a = this.wk_get_cpara_a;
        double[][] a_array = a.getArray();
        NyARMat b = this.wk_get_cpara_b;
        double[][] b_array = b.getArray();
        int i = 0;
        while (i < 4) {
            double[] a_pt0 = a_array[i * 2];
            double[] a_pt1 = a_array[i * 2 + 1];
            int[] world_pti = world[i];
            a_pt0[0] = world_pti[0];
            a_pt0[1] = world_pti[1];
            a_pt0[2] = 1.0;
            a_pt0[3] = 0.0;
            a_pt0[4] = 0.0;
            a_pt0[5] = 0.0;
            a_pt0[6] = -world_pti[0] * i_vertex[i].x;
            a_pt0[7] = -world_pti[1] * i_vertex[i].x;
            a_pt1[0] = 0.0;
            a_pt1[1] = 0.0;
            a_pt1[2] = 0.0;
            a_pt1[3] = world_pti[0];
            a_pt1[4] = world_pti[1];
            a_pt1[5] = 1.0;
            a_pt1[6] = -world_pti[0] * i_vertex[i].y;
            a_pt1[7] = -world_pti[1] * i_vertex[i].y;
            b_array[i * 2 + 0][0] = i_vertex[i].x;
            b_array[i * 2 + 1][0] = i_vertex[i].y;
            ++i;
        }
        if (!a.matrixSelfInv()) {
            return false;
        }
        o_para.matrixMul(a, b);
        return true;
    }

    public boolean pickFromRaster(INyARRgbRaster image, NyARIntPoint2d[] i_vertexs) throws NyARException {
        NyARMat cpara = this.wk_pickFromRaster_cpara;
        int w1 = i_vertexs[0].x - i_vertexs[1].x;
        int w2 = i_vertexs[0].y - i_vertexs[1].y;
        w1 = i_vertexs[2].x - i_vertexs[3].x;
        w2 = i_vertexs[2].y - i_vertexs[3].y;
        int l2 = w1 * w1 + w2 * w2;
        int l1 = w1 * w1 + w2 * w2;
        if (l2 > l1) {
            l1 = l2;
        }
        l1 /= 4;
        int xdiv2 = this._size.w;
        while (xdiv2 * xdiv2 < l1) {
            xdiv2 *= 2;
        }
        if (xdiv2 > 64) {
            xdiv2 = 64;
        }
        w1 = i_vertexs[1].x - i_vertexs[2].x;
        w2 = i_vertexs[1].y - i_vertexs[2].y;
        w1 = i_vertexs[3].x - i_vertexs[0].x;
        w2 = i_vertexs[3].y - i_vertexs[0].y;
        l2 = w1 * w1 + w2 * w2;
        l1 = w1 * w1 + w2 * w2;
        if (l2 > l1) {
            l1 = l2;
        }
        int ydiv2 = this._size.h;
        l1 /= 4;
        while (ydiv2 * ydiv2 < l1) {
            ydiv2 *= 2;
        }
        if (ydiv2 > 64) {
            ydiv2 = 64;
        }
        if (!this.get_cpara(i_vertexs, cpara)) {
            return false;
        }
        this.updateExtpat(image, cpara, xdiv2, ydiv2);
        return true;
    }

    private void reservWorkBuffers(int i_xdiv, int i_ydiv) {
        if (this._last_pix_resolution_x < i_xdiv || this._last_pix_resolution_y < i_ydiv) {
            this.__updateExtpat_xc = new int[i_xdiv * i_ydiv];
            this.__updateExtpat_yc = new int[i_xdiv * i_ydiv];
            this.__updateExtpat_xw = new double[i_xdiv];
            this.__updateExtpat_yw = new double[i_ydiv];
            this.__updateExtpat_rgbset = new int[i_xdiv * i_ydiv * 3];
            this._last_pix_resolution_x = i_xdiv;
            this._last_pix_resolution_y = i_ydiv;
        }
    }

    private void updateExtpat(INyARRgbRaster image, NyARMat i_cpara, int i_xdiv2, int i_ydiv2) throws NyARException {
        int pat_size_w = this._size.w;
        int xdiv = i_xdiv2 / pat_size_w;
        int ydiv = i_ydiv2 / this._size.h;
        int xdiv_x_ydiv = xdiv * ydiv;
        double[][] para = i_cpara.getArray();
        double para00 = para[0][0];
        double para01 = para[1][0];
        double para02 = para[2][0];
        double para10 = para[3][0];
        double para11 = para[4][0];
        double para12 = para[5][0];
        double para20 = para[6][0];
        double para21 = para[7][0];
        INyARRgbPixelReader reader = image.getRgbPixelReader();
        int img_width = image.getWidth();
        int img_height = image.getHeight();
        this.reservWorkBuffers(xdiv, ydiv);
        double[] xw = this.__updateExtpat_xw;
        double[] yw = this.__updateExtpat_yw;
        int[] xc = this.__updateExtpat_xc;
        int[] yc = this.__updateExtpat_yc;
        int[] rgb_set = this.__updateExtpat_rgbset;
        int iy = this._size.h - 1;
        while (iy >= 0) {
            int ix = pat_size_w - 1;
            while (ix >= 0) {
                double reciprocal = 1.0 / (double)i_xdiv2;
                int i = xdiv - 1;
                while (i >= 0) {
                    xw[i] = LT_POS + SQ_SIZE * ((double)(ix * xdiv + i) + 0.5) * reciprocal;
                    --i;
                }
                reciprocal = 1.0 / (double)i_ydiv2;
                i = ydiv - 1;
                while (i >= 0) {
                    yw[i] = LT_POS + SQ_SIZE * ((double)(iy * ydiv + i) + 0.5) * reciprocal;
                    --i;
                }
                int number_of_pix = 0;
                i = ydiv - 1;
                while (i >= 0) {
                    double para01_x_yw_para02 = para01 * yw[i] + para02;
                    double para11_x_yw_para12 = para11 * yw[i] + para12;
                    double para12_x_yw_para22 = para21 * yw[i] + 1.0;
                    int j = xdiv - 1;
                    while (j >= 0) {
                        double d = para20 * xw[j] + para12_x_yw_para22;
                        if (d == 0.0) {
                            throw new NyARException();
                        }
                        int xcw = (int)((para00 * xw[j] + para01_x_yw_para02) / d);
                        int ycw = (int)((para10 * xw[j] + para11_x_yw_para12) / d);
                        if (xcw >= 0 && xcw < img_width && ycw >= 0 && ycw < img_height) {
                            xc[number_of_pix] = xcw;
                            yc[number_of_pix] = ycw;
                            ++number_of_pix;
                        }
                        --j;
                    }
                    --i;
                }
                reader.getPixelSet(xc, yc, number_of_pix, rgb_set);
                int b = 0;
                int g = 0;
                int r = 0;
                i = number_of_pix * 3 - 1;
                while (i >= 0) {
                    r += rgb_set[i - 2];
                    g += rgb_set[i - 1];
                    b += rgb_set[i];
                    i -= 3;
                }
                this._patdata[iy * pat_size_w + ix] = (r / xdiv_x_ydiv & 0xFF) << 16 | (g / xdiv_x_ydiv & 0xFF) << 8 | b / xdiv_x_ydiv & 0xFF;
                --ix;
            }
            --iy;
        }
    }
}

