/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.match;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARCode;
import jp.nyatla.nyartoolkit.core.NyARColorPatt;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPatt;

public class NyARMatchPatt_BlackWhite
implements NyARMatchPatt {
    private double datapow;
    private int width;
    private int height;
    private double cf = 0.0;
    private int dir = 0;
    private int ave;
    private int[][][] input = new int[this.height][this.width][3];

    @Override
    public boolean setPatt(NyARColorPatt i_target_patt) throws NyARException {
        int i2;
        int i;
        this.width = i_target_patt.getWidth();
        this.height = i_target_patt.getHeight();
        int[][][] data = i_target_patt.getPatArray();
        this.input = new int[this.height][this.width][3];
        this.ave = 0;
        int sum = 0;
        for (i = 0; i < this.height; ++i) {
            for (i2 = 0; i2 < this.width; ++i2) {
                this.ave += 255 - data[i][i2][0] + (255 - data[i][i2][1]) + (255 - data[i][i2][2]);
            }
        }
        this.ave /= this.height * this.width * 3;
        for (i = 0; i < this.height; ++i) {
            for (i2 = 0; i2 < this.width; ++i2) {
                this.input[i][i2][0] = (255 - data[i][i2][0] + (255 - data[i][i2][1]) + (255 - data[i][i2][2])) / 3 - this.ave;
                sum += this.input[i][i2][0] * this.input[i][i2][0];
            }
        }
        this.datapow = Math.sqrt(sum);
        return this.datapow != 0.0;
    }

    @Override
    public double getConfidence() {
        return this.cf;
    }

    @Override
    public int getDirection() {
        return this.dir;
    }

    @Override
    public void evaluate(NyARCode i_code) {
        short[][][] patBW = i_code.getPatBW();
        double[] patpowBW = i_code.getPatPowBW();
        double max = 0.0;
        int res = -1;
        for (int j = 0; j < 4; ++j) {
            int sum = 0;
            for (int i = 0; i < this.height; ++i) {
                for (int i2 = 0; i2 < this.width; ++i2) {
                    sum += this.input[i][i2][0] * patBW[j][i][i2];
                }
            }
            double sum2 = (double)sum / patpowBW[j] / this.datapow;
            if (!(sum2 > max)) continue;
            max = sum2;
            res = j;
        }
        this.dir = res;
        this.cf = max;
    }
}

