/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.jmf.utils;

import java.awt.Component;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferStream;
import javax.media.util.BufferToImage;
import jp.nyatla.nyartoolkit.jmf.utils.JmfCaptureListener;
import jp.nyatla.nyartoolkit.jmf.utils.MonitorCDS;

public class MonitorStream
implements PushBufferStream,
BufferTransferHandler {
    JmfCaptureListener img_listener;
    PushBufferStream actual = null;
    boolean dataAvailable = false;
    boolean terminate = false;
    boolean enabled = false;
    Object bufferLock = new Object();
    Buffer cbuffer = new Buffer();
    BufferTransferHandler transferHandler = null;
    Component component = null;
    MonitorCDS cds;
    BufferToImage bti = null;

    MonitorStream(PushBufferStream actual, MonitorCDS cds) {
        this.actual = actual;
        actual.setTransferHandler((BufferTransferHandler)this);
        this.cds = cds;
    }

    public Format getFormat() {
        return this.actual.getFormat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Buffer buffer) throws IOException {
        Object object;
        if (!this.dataAvailable) {
            object = this.bufferLock;
            synchronized (object) {
                while (!this.dataAvailable && !this.terminate) {
                    try {
                        this.bufferLock.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        if (this.dataAvailable) {
            object = this.bufferLock;
            synchronized (object) {
                buffer.copy(this.cbuffer, true);
            }
        }
    }

    public void setCaptureListener(JmfCaptureListener i_listener) {
        this.img_listener = i_listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferData(PushBufferStream pbs) {
        Object object = this.bufferLock;
        synchronized (object) {
            try {
                pbs.read(this.cbuffer);
            }
            catch (IOException ioe) {
                return;
            }
            this.dataAvailable = true;
            this.bufferLock.notifyAll();
        }
        if (this.img_listener != null) {
            this.img_listener.onUpdateBuffer(this.cbuffer);
        }
        if (this.transferHandler != null && this.cds.delStarted) {
            this.transferHandler.transferData((PushBufferStream)this);
        }
    }

    public void setTransferHandler(BufferTransferHandler transferHandler) {
        this.transferHandler = transferHandler;
    }

    public boolean setEnabled(boolean value) {
        this.enabled = value;
        if (!value) {
            if (!this.cds.delStarted) {
                try {
                    this.cds.stopDelegate();
                }
                catch (IOException ioe) {}
            }
        } else {
            try {
                this.cds.startDelegate();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public float setPreviewFrameRate(float rate) {
        System.err.println("TODO");
        return rate;
    }

    public ContentDescriptor getContentDescriptor() {
        return this.actual.getContentDescriptor();
    }

    public long getContentLength() {
        return this.actual.getContentLength();
    }

    public boolean endOfStream() {
        return this.actual.endOfStream();
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String str) {
        return null;
    }
}

