/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.match;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPattDeviationDataDriver_INT1D_X8R8G8B8_32;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPattDeviationDataDriver_RGBAny;
import jp.nyatla.nyartoolkit.core.pixeldriver.INyARRgbPixelDriver;
import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARMatchPattDeviationColorData {
    private int[] _data;
    private double _pow;
    private NyARIntSize _size;
    private INyARRaster _last_input_raster = null;
    private IRasterDriver _last_drv;

    public int[] getData() {
        return this._data;
    }

    public int[] getData(int[] i_buf) {
        System.arraycopy(this._data, 0, i_buf, 0, this._data.length);
        return i_buf;
    }

    public double getPow() {
        return this._pow;
    }

    public NyARMatchPattDeviationColorData(int i_width, int i_height) {
        this._size = new NyARIntSize(i_width, i_height);
        this._data = new int[this._size.w * this._size.h * 3];
    }

    public void setRaster(INyARRgbRaster i_raster) throws NyARException {
        if (this._last_input_raster != i_raster) {
            this._last_drv = (IRasterDriver)i_raster.createInterface(IRasterDriver.class);
            this._last_input_raster = i_raster;
        }
        this._pow = this._last_drv.makeColorData(this._data);
    }

    public final void setRaster(INyARRgbRaster i_raster, int i_direction) throws NyARException {
        int width = this._size.w;
        int height = this._size.h;
        int i_number_of_pix = width * height;
        INyARRgbPixelDriver reader = i_raster.getRgbPixelDriver();
        int[] rgb = new int[3];
        int[] dout = this._data;
        int ave = 0;
        int y = height - 1;
        while (y >= 0) {
            int x = width - 1;
            while (x >= 0) {
                reader.getPixel(x, y, rgb);
                ave += rgb[0] + rgb[1] + rgb[2];
                --x;
            }
            --y;
        }
        ave = i_number_of_pix * 255 * 3 - ave;
        ave = 255 - ave / (i_number_of_pix * 3);
        int sum = 0;
        int input_ptr = i_number_of_pix * 3 - 1;
        switch (i_direction) {
            case 0: {
                int w_sum;
                int y2 = height - 1;
                while (y2 >= 0) {
                    int x = width - 1;
                    while (x >= 0) {
                        reader.getPixel(x, y2, rgb);
                        w_sum = ave - rgb[2];
                        dout[input_ptr--] = w_sum;
                        sum += w_sum * w_sum;
                        w_sum = ave - rgb[1];
                        dout[input_ptr--] = w_sum;
                        sum += w_sum * w_sum;
                        w_sum = ave - rgb[0];
                        dout[input_ptr--] = w_sum;
                        sum += w_sum * w_sum;
                        --x;
                    }
                    --y2;
                }
                break;
            }
            case 1: {
                int w_sum;
                int x = 0;
                while (x < width) {
                    int y3 = height - 1;
                    while (y3 >= 0) {
                        reader.getPixel(x, y3, rgb);
                        w_sum = ave - rgb[2];
                        dout[input_ptr--] = w_sum;
                        sum += w_sum * w_sum;
                        w_sum = ave - rgb[1];
                        dout[input_ptr--] = w_sum;
                        sum += w_sum * w_sum;
                        w_sum = ave - rgb[0];
                        dout[input_ptr--] = w_sum;
                        sum += w_sum * w_sum;
                        --y3;
                    }
                    ++x;
                }
                break;
            }
            case 2: {
                int w_sum;
                int y2 = 0;
                while (y2 < height) {
                    int x = 0;
                    while (x < width) {
                        reader.getPixel(x, y2, rgb);
                        w_sum = ave - rgb[2];
                        dout[input_ptr--] = w_sum;
                        sum += w_sum * w_sum;
                        w_sum = ave - rgb[1];
                        dout[input_ptr--] = w_sum;
                        sum += w_sum * w_sum;
                        w_sum = ave - rgb[0];
                        dout[input_ptr--] = w_sum;
                        sum += w_sum * w_sum;
                        ++x;
                    }
                    ++y2;
                }
                break;
            }
            case 3: {
                int w_sum;
                int x = width - 1;
                while (x >= 0) {
                    int y4 = 0;
                    while (y4 < height) {
                        reader.getPixel(x, y4, rgb);
                        w_sum = ave - rgb[2];
                        dout[input_ptr--] = w_sum;
                        sum += w_sum * w_sum;
                        w_sum = ave - rgb[1];
                        dout[input_ptr--] = w_sum;
                        sum += w_sum * w_sum;
                        w_sum = ave - rgb[0];
                        dout[input_ptr--] = w_sum;
                        sum += w_sum * w_sum;
                        ++y4;
                    }
                    --x;
                }
                break;
            }
        }
        double p = Math.sqrt(sum);
        this._pow = p != 0.0 ? p : 1.0E-7;
    }

    public static interface IRasterDriver {
        public double makeColorData(int[] var1) throws NyARException;
    }

    public static class RasterDriverFactory {
        public static IRasterDriver createDriver(INyARRgbRaster i_raster) {
            switch (i_raster.getBufferType()) {
                case 262402: {
                    return new NyARMatchPattDeviationDataDriver_INT1D_X8R8G8B8_32(i_raster);
                }
            }
            return new NyARMatchPattDeviationDataDriver_RGBAny(i_raster);
        }
    }
}

