/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.transmat.solver;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.NyARMat;
import jp.nyatla.nyartoolkit.core.param.NyARPerspectiveProjectionMatrix;
import jp.nyatla.nyartoolkit.core.transmat.solver.INyARTransportVectorSolver;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint3d;

public class NyARTransportVectorSolver_ARToolKit
implements INyARTransportVectorSolver {
    private final NyARMat _mat_at = new NyARMat(3, 8);
    private final NyARMat _mat_a = new NyARMat(8, 3);
    private final NyARMat _mat_t = new NyARMat(3, 3);
    private final NyARMat _mat_c = new NyARMat(8, 1);
    private final NyARMat _mat_e = new NyARMat(3, 1);
    private final NyARMat _mat_f = new NyARMat(3, 1);
    private double[] _cx = new double[4];
    private double[] _cy = new double[4];
    private final NyARPerspectiveProjectionMatrix _projection_mat;

    public NyARTransportVectorSolver_ARToolKit(NyARPerspectiveProjectionMatrix i_projection_mat_ref) {
        this._projection_mat = i_projection_mat_ref;
        double[][] mata = this._mat_a.getArray();
        double[][] matat = this._mat_at.getArray();
        int i = 0;
        while (i < 4) {
            int x2 = i * 2;
            double d = i_projection_mat_ref.m00;
            matat[0][x2] = d;
            mata[x2][0] = d;
            double d2 = i_projection_mat_ref.m01;
            matat[1][x2] = d2;
            mata[x2][1] = d2;
            matat[0][x2 + 1] = 0.0;
            mata[x2 + 1][0] = 0.0;
            double d3 = i_projection_mat_ref.m11;
            matat[1][x2 + 1] = d3;
            mata[x2 + 1][1] = d3;
            ++i;
        }
    }

    @Override
    public void set2dVertex(NyARDoublePoint2d[] i_ref_vertex_2d, int i_number_of_vertex) throws NyARException {
        assert (i_number_of_vertex == 4);
        double[] cx = this._cx;
        double[] cy = this._cy;
        double cpara02 = this._projection_mat.m02;
        double cpara12 = this._projection_mat.m12;
        NyARMat mat_t = this._mat_t;
        double[][] mata = this._mat_a.getArray();
        double[][] matat = this._mat_at.getArray();
        int i = 0;
        while (i < 4) {
            cx[i] = i_ref_vertex_2d[i].x;
            cy[i] = i_ref_vertex_2d[i].y;
            int x2 = i * 2;
            double d = cpara02 - i_ref_vertex_2d[i].x;
            matat[2][x2] = d;
            mata[x2][2] = d;
            double d2 = cpara12 - i_ref_vertex_2d[i].y;
            matat[2][x2 + 1] = d2;
            mata[x2 + 1][2] = d2;
            ++i;
        }
        mat_t.mul(this._mat_at, this._mat_a);
        mat_t.inverse();
    }

    @Override
    public void solveTransportVector(NyARDoublePoint3d[] i_vertex3d, NyARDoublePoint3d o_transfer) throws NyARException {
        double[][] matc = this._mat_c.getArray();
        double cpara00 = this._projection_mat.m00;
        double cpara01 = this._projection_mat.m01;
        double cpara02 = this._projection_mat.m02;
        double cpara11 = this._projection_mat.m11;
        double cpara12 = this._projection_mat.m12;
        double[] cx = this._cx;
        double[] cy = this._cy;
        int i = 0;
        while (i < 4) {
            int x2 = i + i;
            NyARDoublePoint3d point3d_ptr = i_vertex3d[i];
            matc[x2][0] = point3d_ptr.z * cx[i] - cpara00 * point3d_ptr.x - cpara01 * point3d_ptr.y - cpara02 * point3d_ptr.z;
            matc[x2 + 1][0] = point3d_ptr.z * cy[i] - cpara11 * point3d_ptr.y - cpara12 * point3d_ptr.z;
            ++i;
        }
        this._mat_e.mul(this._mat_at, this._mat_c);
        this._mat_f.mul(this._mat_t, this._mat_e);
        double[][] matf = this._mat_f.getArray();
        o_transfer.x = matf[0][0];
        o_transfer.y = matf[1][0];
        o_transfer.z = matf[2][0];
    }
}

