/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.types.stack;

import java.lang.reflect.Array;
import jp.nyatla.nyartoolkit.core.NyARException;

public class NyARPointerStack<T> {
    protected T[] _items;
    protected int _length;

    protected NyARPointerStack() throws NyARException {
    }

    protected void initInstance(int i_length, Class<T> i_element_type) throws NyARException {
        this._items = (Object[])Array.newInstance(i_element_type, i_length);
        this._length = 0;
    }

    public T push(T i_object) {
        if (this._length >= this._items.length) {
            return null;
        }
        this._items[this._length] = i_object;
        ++this._length;
        return i_object;
    }

    public T pushAssert(T i_object) {
        assert (this._length < this._items.length);
        this._items[this._length] = i_object;
        ++this._length;
        return i_object;
    }

    public T pop() {
        assert (this._length >= 1);
        --this._length;
        return this._items[this._length];
    }

    public final void pops(int i_count) {
        assert (this._length >= i_count);
        this._length -= i_count;
    }

    public final T[] getArray() {
        return this._items;
    }

    public final T getItem(int i_index) {
        return this._items[i_index];
    }

    public final int getLength() {
        return this._length;
    }

    public final int getArraySize() {
        return this._items.length;
    }

    public void remove(int i_index) {
        assert (this._length > i_index && i_index >= 0);
        if (i_index != this._length - 1) {
            int len = this._length - 1;
            T[] items = this._items;
            int i = i_index;
            while (i < len) {
                items[i] = items[i + 1];
                ++i;
            }
        }
        --this._length;
    }

    public void removeIgnoreOrder(int i_index) {
        assert (this._length > i_index && i_index >= 0);
        if (i_index != this._length - 1) {
            this._items[i_index] = this._items[this._length - 1];
        }
        --this._length;
    }

    public void clear() {
        this._length = 0;
    }
}

