/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.rpf.utils;

import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARLinear;
import jp.nyatla.nyartoolkit.rpf.utils.VecLinearCoordinates;

public class VecLinearCoordinatesOperator {
    private static final int _SQ_DIFF_DOT_TH = 200;
    private static final double _SQ_ANG_TH = 0.9848;
    private NyARLinear _l1 = new NyARLinear();
    private NyARLinear _l2 = new NyARLinear();
    private NyARDoublePoint2d _p = new NyARDoublePoint2d();

    public void margeResembleCoords(VecLinearCoordinates i_vector) {
        VecLinearCoordinates.VecLinearCoordinatePoint[] items = i_vector.items;
        NyARLinear l1 = this._l1;
        NyARLinear l2 = this._l2;
        NyARDoublePoint2d p = this._p;
        int i = i_vector.length - 1;
        while (i >= 0) {
            VecLinearCoordinates.VecLinearCoordinatePoint target1 = items[i];
            if (target1.scalar != 0.0) {
                double rdx = target1.dx;
                double rdy = target1.dy;
                double rx = target1.x;
                double ry = target1.y;
                l1.setVector(target1);
                double s_tmp = target1.scalar;
                target1.dx *= s_tmp;
                target1.dy *= s_tmp;
                target1.x *= s_tmp;
                target1.y *= s_tmp;
                int i2 = i - 1;
                while (i2 >= 0) {
                    VecLinearCoordinates.VecLinearCoordinatePoint target2 = items[i2];
                    if (target2.scalar != 0.0 && target2.getVecCos(rdx, rdy) >= 0.9848) {
                        l2.setVector(target2);
                        l1.normalLineCrossPos(rx, ry, l2, p);
                        double l = 0.0;
                        double wx = p.x - rx;
                        double wy = p.y - ry;
                        l += wx * wx + wy * wy;
                        l2.normalLineCrossPos(target2.x, target2.y, l2, p);
                        wx = p.x - target2.x;
                        wy = p.y - target2.y;
                        if (!((l += wx * wx + wy * wy) > 200.0)) {
                            s_tmp = target2.scalar;
                            target1.x += target2.x * s_tmp;
                            target1.y += target2.y * s_tmp;
                            target1.dx += target2.dx * s_tmp;
                            target1.dy += target2.dy * s_tmp;
                            target1.scalar += s_tmp;
                            target2.scalar = 0.0;
                        }
                    }
                    --i2;
                }
            }
            --i;
        }
        i_vector.removeZeroDistItem();
        i = 0;
        while (i < i_vector.length) {
            VecLinearCoordinates.VecLinearCoordinatePoint ptr = items[i];
            double d = 1.0 / ptr.scalar;
            ptr.x *= d;
            ptr.y *= d;
            ptr.dx *= d;
            ptr.dy *= d;
            ++i;
        }
    }
}

