/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.audio.cdaudio;

import com.sun.media.BasicPlayer;
import com.sun.media.amovie.MCI;
import com.sun.media.protocol.file.DataSource;
import com.sun.media.util.LoopThread;
import java.io.IOException;
import javax.media.GainChangeEvent;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;

public class Handler
extends BasicPlayer {
    private int frames;
    private int minutes;
    private int seconds;
    private int hours;
    private int track;
    private int mins;
    private int secs;
    private int frms;
    private int hrs;
    private MCI mci = new MCI();
    private boolean isPlaying = false;
    private byte[] buffer;
    private long nanos;
    private boolean muted;
    private EomThread eomThread;

    public void doClose() {
        super.doClose();
        if (this.eomThread != null) {
            this.eomThread.kill();
        }
    }

    public void setSource(javax.media.protocol.DataSource source) throws IncompatibleSourceException {
        if (!(source instanceof DataSource)) {
            System.out.println("Unsupported data source: " + source);
            throw new IncompatibleSourceException(this + ": doesn't support " + source);
        }
        this.source = source;
    }

    public String convertToMsf(int f2, int s, int m2) {
        if (f2 > 74) {
            f2 %= 75;
            ++s;
        }
        if (s > 59) {
            s %= 60;
            ++m2;
        }
        String st = "" + m2 + ":" + s + ":" + f2;
        return st;
    }

    public void doStart() {
        if (this.eomThread != null) {
            this.eomThread.start();
        }
        this.mci.sendString("set cdaudio time format msf wait");
        String st = this.convertToMsf(this.buffer[36] + this.frms, this.secs + this.buffer[37], this.buffer[38] + this.mins);
        String et = this.convertToMsf(this.buffer[36] + this.buffer[40], this.buffer[37] + this.buffer[41] - 1, this.buffer[38] + this.buffer[42]);
        this.mci.ssendString("open cdaudio shareable wait");
        String comm = "play cdaudio from " + st + " to " + et;
        this.mci.ssendString(comm);
        this.mci.ssendString("close cdaudio wait");
        this.isPlaying = true;
    }

    public void doStop() {
        this.isPlaying = false;
        this.doSetMediaTime(this.getMediaTime());
        this.mci.ssendString("open cdaudio shareable wait");
        this.mci.ssendString("pause cdaudio wait");
        this.mci.ssendString("close cdaudio wait");
        if (this.eomThread != null) {
            this.eomThread.pause();
        }
    }

    protected boolean doRealize() {
        PullSourceStream pss = ((PullDataSource)this.source).getStreams()[0];
        this.buffer = new byte[44];
        int count = 0;
        try {
            count = pss.read(this.buffer, 0, 44);
        }
        catch (IOException e2) {
            // empty catch block
        }
        if (count < 0) {
            this.abortRealize();
            return false;
        }
        this.frames = this.buffer[40];
        this.seconds = this.buffer[41];
        this.minutes = this.buffer[42];
        this.hours = this.buffer[43];
        this.track = this.buffer[22] & 0xFF;
        this.nanos = 60 * this.minutes + this.seconds;
        this.nanos *= 75L;
        this.nanos += (long)this.frames;
        this.nanos *= 40L;
        this.nanos *= 333333L;
        this.setMediaLength(this.nanos);
        this.track |= (this.buffer[23] & 0xFF) << 8;
        this.mci.ssendString("open cdaudio shareable wait");
        this.mci.ssendString("stop cdaudio wait");
        this.mci.ssendString("close cdaudio wait");
        if (this.eomThread == null) {
            this.eomThread = new EomThread(this);
            this.eomThread.start();
        } else {
            this.eomThread.start();
        }
        return true;
    }

    protected boolean audioEnabled() {
        return true;
    }

    protected boolean videoEnabled() {
        return false;
    }

    public void gainChange(GainChangeEvent gce) {
    }

    public void muteChange(boolean state) {
        if (state != this.muted) {
            this.muted = state;
            this.mci.ssendString("open cdaudio shareable wait");
            if (state) {
                this.mci.ssendString("set cdaudio audio all off wait");
            } else {
                this.mci.ssendString("set cdaudio audio all on wait");
            }
            this.mci.ssendString("close cdaudio wait");
        }
    }

    public void updateStats() {
    }

    public Time getDuration() {
        return new Time(this.nanos);
    }

    public TimeBase getMasterTimeBase() {
        return null;
    }

    public void doSetMediaTime(Time time) {
        long now = time.getNanoseconds();
        this.secs = (int)(now / 1000000000L);
        this.hrs = this.secs / 3600;
        this.mins = this.secs / 60;
        this.secs %= 60;
        this.frms = (int)((now %= 1000000000L) / 13333320L);
    }

    public void handleEom() {
        this.setTargetState(500);
        this.processEndOfMedia();
    }

    class EomThread
    extends LoopThread {
        private Handler handler;

        public EomThread(Handler h2) {
            this.handler = h2;
        }

        public boolean process() {
            long now = Handler.this.getMediaTime().getNanoseconds();
            if (now >= Handler.this.nanos) {
                this.handler.stop();
                this.handler.handleEom();
            } else {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return true;
        }
    }
}

