/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp.util;

import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketConsumer;
import com.sun.media.rtp.util.PacketSource;
import com.sun.media.rtp.util.UDPPacket;
import java.io.IOException;
import java.util.Vector;
import javax.media.rtp.SessionAddress;

public abstract class PacketFilter
implements PacketSource,
PacketConsumer {
    PacketSource source;
    PacketConsumer consumer;
    public Vector destAddressList = null;
    public Vector peerlist = null;
    public boolean control = false;

    public abstract Packet handlePacket(Packet var1);

    public abstract Packet handlePacket(Packet var1, int var2);

    public abstract Packet handlePacket(Packet var1, SessionAddress var2);

    public Packet receiveFrom() throws IOException {
        Packet p = null;
        Packet rawp = this.source.receiveFrom();
        if (rawp != null) {
            p = this.handlePacket(rawp);
        }
        return p;
    }

    public void sendTo(Packet p) throws IOException {
        Packet origpacket = p;
        if (this.peerlist != null) {
            p = this.handlePacket(origpacket);
            int i2 = 0;
            while (i2 < this.peerlist.size()) {
                SessionAddress a2 = (SessionAddress)this.peerlist.elementAt(i2);
                if (!this.control) {
                    ((UDPPacket)p).remoteAddress = a2.getDataAddress();
                    ((UDPPacket)p).remotePort = a2.getDataPort();
                } else {
                    ((UDPPacket)p).remoteAddress = a2.getControlAddress();
                    ((UDPPacket)p).remotePort = a2.getControlPort();
                }
                if (p != null && this.consumer != null) {
                    this.consumer.sendTo(p);
                }
                ++i2;
            }
        } else if (this.destAddressList != null) {
            int i3 = 0;
            while (i3 < this.destAddressList.size()) {
                SessionAddress sa = (SessionAddress)this.destAddressList.elementAt(i3);
                p = this.handlePacket(origpacket, sa);
                if (p != null && this.consumer != null) {
                    this.consumer.sendTo(p);
                }
                ++i3;
            }
        } else if (this.destAddressList == null && (p = this.handlePacket(p)) != null && this.consumer != null) {
            this.consumer.sendTo(p);
        }
    }

    public void close() {
    }

    public void closeSource() {
        this.close();
        if (this.source != null) {
            this.source.closeSource();
        }
    }

    public void closeConsumer() {
        this.close();
        if (this.consumer != null) {
            this.consumer.closeConsumer();
        }
    }

    public PacketConsumer getConsumer() {
        return this.consumer;
    }

    public PacketSource getSource() {
        return this.source;
    }

    public Vector getDestList() {
        return null;
    }

    public void setConsumer(PacketConsumer c2) {
        this.consumer = c2;
    }

    public void setSource(PacketSource s) {
        this.source = s;
    }

    public String filtername() {
        return this.getClass().getName();
    }

    public String consumerString() {
        if (this.consumer == null) {
            return this.filtername();
        }
        return this.filtername() + " connected to " + this.consumer.consumerString();
    }

    public String sourceString() {
        if (this.source == null) {
            return this.filtername();
        }
        return this.filtername() + " attached to " + this.source.sourceString();
    }
}

